/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.adv.v2.fields;

import java.util.List;
import org.w3c.dom.Element;
import ru.softlogic.input.model.RowParams;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.parser.FieldAnnotation;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.ScenarioHelper;
import ru.softlogic.parser.adv.v2.ScenarioParserW3C;
import ru.softlogic.parser.adv.v2.fields.FieldParser;

@FieldAnnotation(name="row")
public class RowField
extends FieldParser {
    @Override
    public List<? extends IdentityField> parse(Element field) throws ParseException {
        List<IdentityField> fieldList = ScenarioHelper.getFieldList(field);
        if (!fieldList.isEmpty()) {
            StringBuilder sbRowName = new StringBuilder();
            int totalWidth = 0;
            int widthSetCount = 0;
            for (IdentityField fld : fieldList) {
                sbRowName.append(fld.getId());
                if (fld.getWidth() == 0) continue;
                totalWidth += fld.getWidth();
                ++widthSetCount;
            }
            if (totalWidth > 100) {
                throw new ParseException("Width exceeds 100 percent");
            }
            if (totalWidth == 100 && widthSetCount < fieldList.size()) {
                throw new ParseException("Some items can not be placed. The entire width of the occupied");
            }
            int cnt = fieldList.size() - widthSetCount;
            int avgWidth = cnt == 0 ? cnt : (100 - totalWidth) / cnt;
            String rowName = sbRowName.toString();
            for (IdentityField fld : fieldList) {
                fld.setRowId(rowName);
                if (fld.getWidth() != 0 || avgWidth == 0) continue;
                fld.setWidth(avgWidth);
            }
            ScenarioParserW3C.getRowParamsMap().put(rowName, new RowParams(this.getOrientation(field)));
        }
        return fieldList;
    }
}

