/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.adv.v2.fields;

import java.util.Collections;
import java.util.List;
import org.w3c.dom.Element;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.input.model.field.autocomplete.AutoCompleteField;
import ru.softlogic.input.model.field.autocomplete.DataStore;
import ru.softlogic.parser.FieldAnnotation;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.adv.v2.fields.FieldParser;
import ru.softlogic.parser.factory.KeyboardFactory;
import ru.softlogic.parser.factory.autocomplete.AutocompleteDataStoreFactory;

@FieldAnnotation(name="autocomplete-field")
public class AutocompleteField
extends FieldParser {
    @Override
    public List<? extends IdentityField> parse(Element field) throws ParseException {
        AutoCompleteField acf = new AutoCompleteField();
        acf.setId(this.getId(field));
        acf.setGroupId(this.getGroupId(field));
        acf.setTitle(AutocompleteField.getAttribute(field, "title"));
        acf.setTitleId(AutocompleteField.getAttribute(field, "title-id"));
        acf.setMessage(AutocompleteField.getAttribute(field, "message"));
        acf.setMessageId(AutocompleteField.getAttribute(field, "message-id"));
        acf.setHelpSoftwareTypeMap(this.getHelp(field));
        acf.setFlags(this.getFlags(field));
        acf.setExist(this.getExist(field));
        acf.setKeyboard(KeyboardFactory.createAdv(field));
        acf.setExampleValue(AutocompleteField.getAttribute(field, "example"));
        String minchars = AutocompleteField.getAttribute(field, "min-chars");
        String maxitems = AutocompleteField.getAttribute(field, "max-items");
        acf.setMinChars(Integer.parseInt(minchars));
        acf.setMaxItems(Integer.parseInt(maxitems));
        acf.setOptional("true".equalsIgnoreCase(AutocompleteField.getAttribute(field, "optional")));
        acf.setAllowCustom("true".equalsIgnoreCase(AutocompleteField.getAttribute(field, "allow-custom")));
        Element dsSection = AutocompleteField.getElement(field, "data-source");
        DataStore pds = AutocompleteDataStoreFactory.create(dsSection);
        acf.setDataStore(pds);
        return Collections.singletonList(acf);
    }
}

