/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.adv.v2.actions;

import java.util.LinkedList;
import java.util.List;
import org.w3c.dom.Element;
import ru.softlogic.input.model.advanced.actions.ActionElement;
import ru.softlogic.input.model.advanced.actions.conditional.Case;
import ru.softlogic.input.model.advanced.actions.conditional.Switch;
import ru.softlogic.parser.ActionAnnotation;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.ScenarioHelper;
import ru.softlogic.parser.adv.v2.ParserContext;
import ru.softlogic.parser.adv.v2.actions.ParseAction;

@ActionAnnotation(name="switch")
public class SwitchAction
extends ParseAction {
    @Override
    public ActionElement parse(Element element, ParserContext context) throws ParseException {
        Switch res = new Switch();
        String attrExpression = SwitchAction.getAttribute(element, "expression");
        String attribute = SwitchAction.getAttribute(element, "value");
        if (attrExpression != null) {
            res.setExpression(attrExpression);
        } else if (attribute != null) {
            res.setValue(attribute);
        }
        boolean isExpresion = res.getValue() == null && res.getExpression() == null;
        res.setCases(this.createCase(element, isExpresion, context));
        Element defaultCase = SwitchAction.getElement(element, "default");
        if (defaultCase != null) {
            Case defCase = new Case();
            defCase.setValue("default");
            defCase.setSequence(ScenarioHelper.createActionSequence(defaultCase, context));
            res.setDefaultCase(defCase);
        }
        return res;
    }

    private List<Case> createCase(Element element, boolean isExpression, ParserContext context) throws ParseException {
        LinkedList<Case> cases = new LinkedList<Case>();
        for (Element el : SwitchAction.getElements(element, "case")) {
            Case c = new Case();
            if (isExpression) {
                c.setExpression(SwitchAction.getAttribute(el, "expression"));
            } else {
                String value = SwitchAction.getNotNullAttribute(el, "value", "Case.Expected \"value\": ");
                c.setValue(value);
            }
            c.setSequence(ScenarioHelper.createActionSequence(el, context));
            cases.add(c);
        }
        return cases;
    }
}

