/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.adv.v2.actions;

import java.util.HashMap;
import java.util.List;
import org.w3c.dom.Element;
import ru.softlogic.input.model.advanced.MethodType;
import ru.softlogic.input.model.advanced.OpenUrlTarget;
import ru.softlogic.input.model.advanced.actions.ActionElement;
import ru.softlogic.input.model.advanced.actions.simple.OpenUrl;
import ru.softlogic.parser.ActionAnnotation;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.adv.v2.ParserContext;
import ru.softlogic.parser.adv.v2.actions.ParseAction;

@ActionAnnotation(name="open-url")
public class OpenUrlAction
extends ParseAction {
    @Override
    public ActionElement parse(Element element, ParserContext context) throws ParseException {
        OpenUrl openUrl = new OpenUrl();
        openUrl.setUrl(OpenUrlAction.getAttribute(element, "url"));
        String encoding = OpenUrlAction.getAttribute(element, "encoding");
        openUrl.setEncoding(encoding != null ? encoding : "UTF-8");
        String target = OpenUrlAction.getAttribute(element, "target");
        if (target != null) {
            OpenUrlTarget openUrlTarget = OpenUrlTarget.valueOf((String)target.toUpperCase());
            openUrl.setTarget(openUrlTarget);
        } else {
            openUrl.setTarget(OpenUrlTarget.SELF);
        }
        String method = OpenUrlAction.getAttribute(element, "method");
        if (method != null) {
            MethodType methodType = MethodType.valueOf((String)method.toUpperCase());
            openUrl.setMethodType(methodType);
        } else {
            openUrl.setMethodType(MethodType.GET);
        }
        HashMap<String, String> params = new HashMap<String, String>();
        List<Element> elements = OpenUrlAction.getElements(element, "param");
        for (Element elem : elements) {
            params.put(OpenUrlAction.getAttribute(elem, "id"), OpenUrlAction.getAttribute(elem, "from"));
        }
        openUrl.setParams(params);
        return openUrl;
    }
}

