/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.adv.v2.actions;

import java.util.ArrayList;
import org.w3c.dom.Element;
import ru.softlogic.input.model.advanced.actions.ActionElement;
import ru.softlogic.input.model.advanced.actions.ActionMap;
import ru.softlogic.input.model.advanced.actions.dialog.DialogAction;
import ru.softlogic.input.model.advanced.actions.dialog.DialogType;
import ru.softlogic.parser.ActionAnnotation;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.ScenarioHelper;
import ru.softlogic.parser.adv.v2.ParserContext;
import ru.softlogic.parser.adv.v2.actions.ParseAction;

@ActionAnnotation(name="dialog")
public class DialogsAction
extends ParseAction {
    @Override
    public ActionElement parse(Element element, ParserContext context) throws ParseException {
        ActionMap actionMap;
        DialogAction da = new DialogAction();
        da.setType(DialogType.valueOf((String)element.getAttribute("type")));
        da.setTitle(element.getAttribute("title"));
        da.setTitleId(element.getAttribute("title-id"));
        da.setTimeout(Integer.parseInt(element.getAttribute("timeout")));
        da.setDefaultAction(element.getAttribute("default"));
        da.setMessage(this.getMessage(element));
        da.setMessageId(DialogsAction.getAttribute(element, "message-id"));
        String params = element.getAttribute("mess-params");
        if (!params.isEmpty()) {
            String[] split = params.split(",");
            ArrayList<String> keys = new ArrayList<String>();
            for (String key : split) {
                String trimKey = key.trim();
                if (trimKey.isEmpty()) continue;
                keys.add(trimKey);
            }
            if (!keys.isEmpty()) {
                da.setMessParams(keys);
            }
        }
        if ((actionMap = ScenarioHelper.createActionMap(element, context)) == null) {
            throw new ParseException("Dialog. Section 'actions' not found");
        }
        da.setActionMap(actionMap);
        return da;
    }
}

