/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.adv.v2.actions;

import org.w3c.dom.Element;
import ru.softlogic.input.model.advanced.actions.ActionElement;
import ru.softlogic.input.model.advanced.actions.simple.DateUtil;
import ru.softlogic.parser.ActionAnnotation;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.adv.v2.ParserContext;
import ru.softlogic.parser.adv.v2.actions.ParseAction;

@ActionAnnotation(name="date-util")
public class DateUtilAction
extends ParseAction {
    @Override
    public ActionElement parse(Element element, ParserContext context) throws ParseException {
        String srcKey = DateUtilAction.getNotNullAttribute(element, "src-key", "'date-util' does not contain 'src-key'");
        String targetKey = DateUtilAction.getNotNullAttribute(element, "target-key", "'date-util' does not contain 'target-key'");
        String inputFormat = DateUtilAction.getNotNullAttribute(element, "input-format", "'date-util' does not contain 'input-format'");
        String outputFormat = DateUtilAction.getNotNullAttribute(element, "output-format", "'date-util' does not contain output-format'");
        int field = this.getIntValue(element, "field");
        int amount = this.getIntValue(element, "amount");
        return new DateUtil(srcKey, targetKey, inputFormat, outputFormat, field, amount);
    }

    private int getIntValue(Element el, String name) throws ParseException {
        try {
            return Integer.parseInt(DateUtilAction.getAttribute(el, name));
        }
        catch (NumberFormatException ex) {
            throw new ParseException("Attribute " + name + " can not be converted to a number");
        }
    }
}

