/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.adv.v2.actions;

import org.w3c.dom.Element;
import ru.softlogic.input.model.advanced.actions.ActionElement;
import ru.softlogic.input.model.advanced.actions.validator.BankAccountValidator;
import ru.softlogic.input.model.advanced.actions.validator.BlockValidator;
import ru.softlogic.input.model.advanced.actions.validator.CapacityValidator;
import ru.softlogic.input.model.advanced.actions.validator.LocalCapacityValidator;
import ru.softlogic.input.model.advanced.actions.validator.PurchaseValidator;
import ru.softlogic.parser.ActionAnnotation;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.ScenarioHelper;
import ru.softlogic.parser.adv.v2.ParserContext;
import ru.softlogic.parser.adv.v2.actions.ParseAction;

@ActionAnnotation(name="complex-validator")
public class ComplexValidatorAction
extends ParseAction {
    @Override
    public ActionElement parse(Element element, ParserContext context) throws ParseException {
        String type = ComplexValidatorAction.getAttribute(element, "type");
        if ("bank-account".equals(type)) {
            BankAccountValidator bak = new BankAccountValidator();
            bak.setBikKey(ComplexValidatorAction.getAttribute(element, "bik-key"));
            bak.setAccountKey(ComplexValidatorAction.getAttribute(element, "account-key"));
            bak.setBankKey(ComplexValidatorAction.getAttribute(element, "bank-key"));
            bak.setActionMap(ScenarioHelper.createActionMap(element, context));
            return bak;
        }
        if ("local-capacity".equals(type)) {
            LocalCapacityValidator lcv = new LocalCapacityValidator();
            lcv.setAccountKey(ComplexValidatorAction.getAttribute(element, "account-key"));
            lcv.setFunction(ComplexValidatorAction.getAttribute(element, "function"));
            lcv.setActionMap(ScenarioHelper.createActionMap(element, context));
            return lcv;
        }
        if ("capacity".equals(type)) {
            CapacityValidator cv = new CapacityValidator();
            cv.setNumber(ComplexValidatorAction.getAttribute(element, "number"));
            cv.setActionMap(ScenarioHelper.createActionMap(element, context));
            return cv;
        }
        if ("block".equals(type)) {
            BlockValidator bv = new BlockValidator();
            bv.setAccountKey(ComplexValidatorAction.getAttribute(element, "key"));
            bv.setFunction(ComplexValidatorAction.getAttribute(element, "function"));
            bv.setActionMap(ScenarioHelper.createActionMap(element, context));
            return bv;
        }
        if ("purchase-validator".equals(type)) {
            PurchaseValidator pv = new PurchaseValidator();
            pv.setSumElement(ComplexValidatorAction.getAttribute(element, "sum"));
            pv.setMinValidate(Boolean.valueOf(ComplexValidatorAction.getAttribute(element, "check-min")).booleanValue());
            pv.setActionMap(ScenarioHelper.createActionMap(element, context));
            return pv;
        }
        throw new ParseException("Unknown validator's type : " + type);
    }
}

