/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.adv.v2;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import ru.softlogic.input.model.advanced.AdvancedScreenDescription;
import ru.softlogic.input.model.advanced.Scenario;
import ru.softlogic.input.model.advanced.SlaveScenarioException;
import ru.softlogic.input.model.advanced.SlaveScenarioParser;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.adv.ScenarioParser;

class ScreenParserImpl
implements SlaveScenarioParser {
    public static final long serialVersionUID = 0L;
    private final File file;
    private final ScenarioParser parser;

    public ScreenParserImpl(ScenarioParser parser, File file) {
        this.file = file;
        this.parser = parser;
    }

    public Map<String, AdvancedScreenDescription> parse() throws SlaveScenarioException {
        if (this.file != null && this.file.exists()) {
            try {
                Scenario scenario = this.parser.parse(new File(this.file.getAbsolutePath().replace(".xml", "_slave.xml")));
                return scenario.getScreens();
            }
            catch (ParseException ex) {
                throw new SlaveScenarioException("Slave scenario parsing error");
            }
        }
        return new HashMap<String, AdvancedScreenDescription>();
    }
}

