/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser.adv;

import java.io.File;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import ru.softlogic.input.model.advanced.Scenario;
import ru.softlogic.input.model.advanced.configuration.RuntimeConfiguration;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.ParserUtility;
import ru.softlogic.parser.Store;
import ru.softlogic.parser.adv.Parser;

public class ScenarioStore
implements Store {
    private final File basePath;
    private final File encodePath;
    private final Map<String, SoftReference<Scenario>> forms;
    private String password;

    public ScenarioStore(File basePath) {
        this(basePath, null);
    }

    public ScenarioStore(File basePath, File encodePath) {
        if (basePath == null) {
            throw new NullPointerException("Base path");
        }
        this.basePath = basePath;
        this.encodePath = encodePath;
        this.forms = new HashMap<String, SoftReference<Scenario>>();
    }

    @Override
    public synchronized void clear() {
        this.forms.clear();
    }

    public synchronized Scenario getScenario(int code, Locale locale, String password) throws ParseException {
        this.password = password;
        return this.getScenario(code, locale);
    }

    public synchronized Scenario getScenario(int code, Locale locale) throws ParseException {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if (!ParserUtility.isAdvCacheUse()) {
            this.forms.clear();
        }
        if (this.password != null) {
            try {
                return this.getScenario(code, "_" + locale.getLanguage() + ".enc");
            }
            catch (ParseException ex) {
                try {
                    return this.getScenario(code, ".enc");
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        try {
            return this.getScenario(code, "_" + locale.getLanguage() + ".xml");
        }
        catch (ParseException ex) {
            return this.getScenario(code, ".xml");
        }
    }

    private Scenario getScenario(int code, String suffix) throws ParseException {
        String id = Integer.toString(code) + suffix;
        if (this.forms.containsKey(id)) {
            SoftReference<Scenario> srf = this.forms.get(id);
            if (srf != null) {
                Scenario f = srf.get();
                if (f == null) {
                    f = this.readScenarioRes(code, suffix);
                    this.forms.put(id, new SoftReference<Scenario>(f));
                }
                return f;
            }
        } else {
            Scenario f = this.readScenarioRes(code, suffix);
            if (f != null) {
                this.forms.put(id, new SoftReference<Scenario>(f));
                return f;
            }
            this.forms.put(id, null);
        }
        return null;
    }

    private Scenario readScenarioRes(int code, String postfix) throws ParseException {
        RuntimeConfiguration.getInstance().setEncodePath(this.encodePath);
        RuntimeConfiguration.getInstance().setPassword(this.password);
        return Parser.parse(new File(this.basePath, code + postfix));
    }
}

