/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser;

import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.softlogic.parser.ActionAnnotation;
import ru.softlogic.parser.FieldAnnotation;
import ru.softlogic.parser.ParseElementSearcherEngine;
import ru.softlogic.parser.ScreenAnnotation;
import ru.softlogic.parser.adv.v2.actions.ParseAction;
import ru.softlogic.parser.adv.v2.fields.FieldParser;
import ru.softlogic.parser.adv.v2.screens.ScreenParser;

public class DynamicParseElementSearcher
implements ParseElementSearcherEngine {
    private static final Logger log = LoggerFactory.getLogger((String)"pay");
    private static Map<String, ScreenParser> screens;
    private static Map<String, FieldParser> fields;
    private static Map<String, ParseAction> actions;
    private static final List<String> allowed;
    private static List<Class> classes;

    @Override
    public synchronized Map<String, ScreenParser> getAllScreens() {
        if (screens == null) {
            List<Class> l = DynamicParseElementSearcher.getClasses();
            HashMap<String, ScreenParser> map = new HashMap<String, ScreenParser>();
            for (Class cl : l) {
                if (!cl.isAnnotationPresent(ScreenAnnotation.class)) continue;
                try {
                    String[] paths;
                    ScreenAnnotation annotation = cl.getAnnotation(ScreenAnnotation.class);
                    ScreenParser ps = (ScreenParser)cl.newInstance();
                    map.put(annotation.name(), ps);
                    if (annotation.alias() == null || annotation.alias().isEmpty()) continue;
                    for (String s : paths = annotation.alias().split(",")) {
                        map.put(s, ps);
                    }
                }
                catch (InstantiationException ex) {
                    log.error("getAllScreens", (Throwable)ex);
                }
                catch (IllegalAccessException ex) {
                    log.error("getAllScreens", (Throwable)ex);
                }
                catch (ClassCastException ex) {
                    log.error("getAllScreens", (Throwable)ex);
                }
            }
            screens = Collections.unmodifiableMap(map);
            DynamicParseElementSearcher.printMap("Screens map: ", screens);
        }
        return screens;
    }

    @Override
    public synchronized Map<String, FieldParser> getAllFields() {
        if (fields == null) {
            List<Class> l = DynamicParseElementSearcher.getClasses();
            HashMap<String, FieldParser> map = new HashMap<String, FieldParser>();
            for (Class cl : l) {
                if (!cl.isAnnotationPresent(FieldAnnotation.class)) continue;
                try {
                    FieldAnnotation annotation = cl.getAnnotation(FieldAnnotation.class);
                    FieldParser pf = (FieldParser)cl.newInstance();
                    map.put(annotation.name(), pf);
                }
                catch (Exception ex) {
                    log.warn("Error creating {}. Cause: {}", (Object)cl.getName(), (Object)ex.getMessage());
                }
            }
            fields = Collections.unmodifiableMap(map);
            DynamicParseElementSearcher.printMap("Fields map: ", fields);
        }
        return fields;
    }

    @Override
    public synchronized Map<String, ParseAction> getAllActions() {
        if (actions == null) {
            List<Class> l = DynamicParseElementSearcher.getClasses();
            HashMap<String, ParseAction> map = new HashMap<String, ParseAction>();
            for (Class cl : l) {
                if (!cl.isAnnotationPresent(ActionAnnotation.class)) continue;
                try {
                    ActionAnnotation annotation = cl.getAnnotation(ActionAnnotation.class);
                    ParseAction ps = (ParseAction)cl.newInstance();
                    map.put(annotation.name(), ps);
                }
                catch (Exception ex) {
                    log.error("getAllActions", (Throwable)ex);
                }
            }
            actions = Collections.unmodifiableMap(map);
            DynamicParseElementSearcher.printMap("Actions map: ", actions);
        }
        return actions;
    }

    public static synchronized List<Class> getClasses() {
        if (classes == null) {
            final ArrayList<Class> list = new ArrayList<Class>();
            ClassFinder.findClasses(new Visitor<Class>(){

                @Override
                public void visit(Class cl) {
                    list.add(cl);
                }
            });
            classes = list;
        }
        return classes;
    }

    protected static void printMap(String message, Map<String, ? extends Object> map) {
        log.info(message);
        for (Map.Entry<String, ? extends Object> entry : map.entrySet()) {
            log.info("    {} -> {}", (Object)entry.getKey(), entry.getValue().getClass());
        }
    }

    private static boolean isAllowed(String path) {
        for (String a : allowed) {
            if (!path.startsWith(a)) continue;
            return true;
        }
        return false;
    }

    static {
        allowed = new LinkedList<String>();
        allowed.add("ru.softlogic.parser.factory");
        allowed.add("ru.softlogic.parser.adv.v2.actions");
        allowed.add("ru.softlogic.parser.adv.v2.fields");
        allowed.add("ru.softlogic.parser.adv.v2.screens");
        allowed.add("ru.softlogic.parser.uni.v2");
    }

    static class ClassFinder {
        private ClassFinder() {
        }

        public static void findClasses(Visitor<Class> visitor) {
            try {
                File file = new File(DynamicParseElementSearcher.class.getProtectionDomain().getCodeSource().getLocation().toURI().getPath());
                if (file.exists()) {
                    ClassFinder.findClasses(file, file, true, visitor);
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static void findClasses(File root, File file, boolean includeJars, Visitor<Class> visitor) {
            block16: {
                try {
                    if (file.isDirectory()) {
                        for (File child : file.listFiles()) {
                            ClassFinder.findClasses(root, child, includeJars, visitor);
                        }
                        break block16;
                    }
                    if (file.getName().toLowerCase().endsWith(".jar") && includeJars) {
                        JarFile jar = null;
                        try {
                            jar = new JarFile(file);
                            Enumeration<JarEntry> entries = jar.entries();
                            while (entries.hasMoreElements()) {
                                String classname;
                                JarEntry entry = entries.nextElement();
                                String name = entry.getName();
                                int extIndex = name.lastIndexOf(".class");
                                if (extIndex <= 0 || !DynamicParseElementSearcher.isAllowed(classname = name.replace('/', '.').substring(0, name.length() - 6))) continue;
                                visitor.visit(Class.forName(classname));
                            }
                            break block16;
                        }
                        finally {
                            try {
                                if (jar != null) {
                                    jar.close();
                                }
                            }
                            catch (IOException iOException) {}
                        }
                    }
                    if (file.getName().toLowerCase().endsWith(".class")) {
                        visitor.visit(ClassFinder.createClassName(file));
                    }
                }
                catch (ClassNotFoundException ex) {
                    log.warn("Class find error: {}", (Object)ex.getMessage());
                }
                catch (IOException ex) {
                    log.warn("Class find error: {}", (Object)ex.getMessage());
                }
            }
        }

        private static Class createClassName(File file) throws ClassNotFoundException {
            StringBuilder sb = new StringBuilder();
            String fileName = file.getName();
            sb.append(fileName.substring(0, fileName.lastIndexOf(".class")));
            String packageFileName = "";
            for (File parentFile = file.getParentFile(); parentFile != null; parentFile = parentFile.getParentFile()) {
                String prevPackageFileName = packageFileName;
                packageFileName = parentFile.getName();
                sb.insert(0, '.').insert(0, packageFileName);
                if ("softlogic".equals(prevPackageFileName) && "ru".equals(packageFileName)) break;
            }
            return Class.forName(sb.toString());
        }
    }

    private static interface Visitor<T> {
        public void visit(T var1);
    }
}

