/*
 * Decompiled with CFR 0.152.
 */
package ru.softlogic.parser;

import java.io.File;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import ru.softlogic.input.model.InputElement;
import ru.softlogic.input.model.PrefillItem;
import ru.softlogic.input.model.advanced.configuration.RuntimeConfiguration;
import ru.softlogic.input.model.advanced.configuration.SoftwareType;
import ru.softlogic.input.model.field.IdentityField;
import ru.softlogic.input.model.field.date.AbsoluteDateRange;
import ru.softlogic.input.model.field.date.DateRange;
import ru.softlogic.input.model.field.date.RelativeDateRange;
import ru.softlogic.input.model.field.date.RelativeRangeValue;
import ru.softlogic.input.model.field.selector.ItemsStore;
import ru.softlogic.input.model.field.selector.SelectorItem;
import ru.softlogic.input.model.field.text.AndValidator;
import ru.softlogic.input.model.field.text.NotEmptyValidator;
import ru.softlogic.input.model.field.text.Validator;
import ru.softlogic.parser.ParseException;
import ru.softlogic.parser.ParserHelper;
import ru.softlogic.parser.ParserParams;

public class BaseElementParser {
    private static final int MAX_ID_LEN = 40;

    protected Integer getIntAttribute(Element element, String attr) throws ParseException {
        String value = BaseElementParser.getAttribute(element, attr);
        if (value == null) {
            return null;
        }
        if (!value.matches("-?\\d+")) {
            throw new ParseException("Attribute " + attr + " wrong value: " + value);
        }
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException ex) {
            throw new ParseException("Error on parse attribute " + attr, ex);
        }
    }

    protected Short getShortAttribute(Element element, String attr) throws ParseException {
        String value = BaseElementParser.getAttribute(element, attr);
        if (value == null) {
            return null;
        }
        if (!value.matches("-?\\d+")) {
            throw new ParseException("Attribute " + attr + " wrong value: " + value);
        }
        try {
            return Short.parseShort(value);
        }
        catch (NumberFormatException ex) {
            throw new ParseException("Error on parse attribute " + attr, ex);
        }
    }

    protected int getIntAttribute(Element element, String attr, int def) throws ParseException {
        Integer value = this.getIntAttribute(element, attr);
        return value == null ? def : value;
    }

    protected Integer getIntAttribute(Element element, String attr, int min, int max) throws ParseException {
        Integer value = this.getIntAttribute(element, attr);
        if (value == null) {
            return null;
        }
        if (value < min || value > max) {
            throw new ParseException("Attribute " + attr + " must be in range: [" + min + "," + max + "]");
        }
        return value;
    }

    protected Integer getIntAttribute(Element element, String attr, int def, int min, int max) throws ParseException {
        int value = this.getIntAttribute(element, attr, def);
        if (value < min || value > max) {
            throw new ParseException("Attribute " + attr + " must be in range: [" + min + "," + max + "]");
        }
        return value;
    }

    protected static Element getElement(Element element, String name) {
        return ParserHelper.getElement(element, name);
    }

    protected static List<Element> getElements(Element element, String name) {
        return ParserHelper.getElements(element, name);
    }

    protected static Element getNotNullElement(Element element, String name, String errorMessage) throws ParseException {
        return ParserHelper.getNotNullElement(element, name, errorMessage);
    }

    protected static List<Element> getChildElements(Element element) {
        return ParserHelper.getChildElements(element);
    }

    protected static String getAttribute(Element el, String name) {
        return ParserHelper.getAttribute(el, name);
    }

    protected static String getNotNullAttribute(Element el, String name, String msg) throws ParseException {
        return ParserHelper.getNotNullAttribute(el, name, msg);
    }

    protected String getMessage(Element element) {
        return BaseElementParser.getAttribute(element, "message");
    }

    protected List<InputElement> parseInputElements(Element element, String childName) {
        LinkedList<InputElement> lie = new LinkedList<InputElement>();
        for (Element el : BaseElementParser.getElements(element, childName)) {
            lie.add(this.createIeFromElement(el));
        }
        return lie;
    }

    protected InputElement createIeFromElement(Element el) {
        InputElement ie = new InputElement(BaseElementParser.getAttribute(el, "key"), BaseElementParser.getAttribute(el, "key-title"), BaseElementParser.getAttribute(el, "value"), BaseElementParser.getAttribute(el, "value-title"), this.getFlags(el));
        ie.setKeyTitleId(BaseElementParser.getAttribute(el, "key-title-id"));
        ie.setValueTitleId(BaseElementParser.getAttribute(el, "value-title-id"));
        return ie;
    }

    protected int getFlags(Element element) {
        String fl = BaseElementParser.getAttribute(element, "flags");
        if (fl == null) {
            return 0;
        }
        int flagsMask = 0;
        String[] strFlagArray = fl.split("\\|");
        if (strFlagArray.length == 1) {
            try {
                if (fl.startsWith("0x") || fl.startsWith("0X")) {
                    fl = fl.substring(2);
                }
                return Integer.parseInt(fl, 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        for (String strFlag : strFlagArray) {
            String code = strFlag.trim();
            if ("HIDE_ON_CONFIRM".equalsIgnoreCase(code)) {
                flagsMask |= 1;
                continue;
            }
            if ("HIDE_ON_PRINT".equalsIgnoreCase(code)) {
                flagsMask |= 2;
                continue;
            }
            if ("HIDE_ON_SERVER".equalsIgnoreCase(code)) {
                flagsMask |= 4;
                continue;
            }
            if ("USE_CONTACTS".equalsIgnoreCase(code)) {
                flagsMask |= 0x10;
                continue;
            }
            if ("VALIDATE_BY_CAPACITY".equalsIgnoreCase(code)) {
                flagsMask |= 0x20;
                continue;
            }
            if ("HIDE_FROM_EXTERNAL".equalsIgnoreCase(code)) {
                flagsMask |= 0x100;
                continue;
            }
            if ("HIDE_ON_FRONTEND".equalsIgnoreCase(code)) {
                flagsMask |= 0x200;
                continue;
            }
            if ("MASKED".equalsIgnoreCase(code)) {
                flagsMask |= 0x800;
                continue;
            }
            if ("FLAG_VALUE_IS_UNCHANGED".equalsIgnoreCase(code)) {
                flagsMask |= 0x400;
                continue;
            }
            if ("FLAG_MASK_IN_LOGS".equalsIgnoreCase(code)) {
                flagsMask |= 0x800;
                continue;
            }
            if ("FLAG_IMAGE_URL".equalsIgnoreCase(code)) {
                flagsMask |= 0x1000;
                continue;
            }
            if ("FLAG_EXTERNAL_URL".equalsIgnoreCase(code)) {
                flagsMask |= 0x2000;
                continue;
            }
            if (!"FLAG_USE_CONTACTS".equalsIgnoreCase(code)) continue;
            flagsMask |= 0x10;
        }
        return flagsMask;
    }

    protected String getTitle(Element element) {
        String title = BaseElementParser.getAttribute(element, "title");
        return title != null ? title : this.getMessage(element);
    }

    public static String processPaths(String source) {
        String result = source;
        String regex = "\\\"\\s*(\\$terminal_home(\\/.*))\\s*\\\"";
        Matcher m = Pattern.compile(regex).matcher(result);
        String homePath = RuntimeConfiguration.getInstance().getHomePath();
        while (m.find()) {
            result = result.replace(m.group(1), new File(homePath + m.group(2)).toURI().toString());
        }
        return result;
    }

    protected Map<SoftwareType, String> getHelp(Element element) {
        return this.getHelp(element, "help");
    }

    protected Map<SoftwareType, String> getHelp(Element element, String attrName) {
        List<Element> helps = BaseElementParser.getElements(element, attrName);
        EnumMap<SoftwareType, String> map = new EnumMap<SoftwareType, String>(SoftwareType.class);
        for (Element help : helps) {
            String strTypes = BaseElementParser.getAttribute(help, "types");
            String text = help.getTextContent().trim();
            text = text.replace("\\n", "\n").replaceAll("\n|\t", "");
            if (strTypes != null) {
                for (SoftwareType type : this.parseTypes(strTypes)) {
                    map.put(type, BaseElementParser.processPaths(text));
                }
                continue;
            }
            map.put(SoftwareType.Any, BaseElementParser.processPaths(text));
        }
        return map;
    }

    private boolean hasBit(int value, int mask) {
        return (value & mask) > 0;
    }

    private List<SoftwareType> parseTypes(String strTypes) {
        ArrayList<SoftwareType> types = new ArrayList<SoftwareType>();
        if (strTypes == null) {
            return types;
        }
        String[] strTypesArray = strTypes.split("\\|");
        if (strTypesArray.length == 1) {
            try {
                int intType = Integer.parseInt(strTypes, 16);
                if (this.hasBit(intType, 1)) {
                    types.add(SoftwareType.Terminal);
                } else if (this.hasBit(intType, 4)) {
                    types.add(SoftwareType.Keeper);
                } else if (this.hasBit(intType, 8)) {
                    types.add(SoftwareType.Keeper_Android);
                } else if (this.hasBit(intType, 16)) {
                    types.add(SoftwareType.Keeper_Ios);
                } else if (this.hasBit(intType, 32)) {
                    types.add(SoftwareType.Keeper_Web);
                } else if (this.hasBit(intType, 64)) {
                    types.add(SoftwareType.Mobile_Android);
                } else if (this.hasBit(intType, 128)) {
                    types.add(SoftwareType.Mobile_Ios);
                }
                return types;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        for (String strType : strTypesArray) {
            String code = strType.trim();
            if ("TERMINAL".equalsIgnoreCase(code)) {
                types.add(SoftwareType.Terminal);
                continue;
            }
            if ("KEEPER".equalsIgnoreCase(code)) {
                types.add(SoftwareType.Keeper);
                continue;
            }
            if ("RMA".equalsIgnoreCase(code)) {
                types.add(SoftwareType.RMA);
                continue;
            }
            if ("KEEPER-IOS".equalsIgnoreCase(code)) {
                types.add(SoftwareType.Keeper_Ios);
                continue;
            }
            if ("KEEPER-ANDROID".equalsIgnoreCase(code)) {
                types.add(SoftwareType.Keeper_Android);
                continue;
            }
            if ("KEEPER-WEB".equalsIgnoreCase(code)) {
                types.add(SoftwareType.Keeper_Web);
                continue;
            }
            if ("MOBILE-ANDROID".equalsIgnoreCase(code)) {
                types.add(SoftwareType.Mobile_Android);
                continue;
            }
            if (!"MOBILE-IOS".equalsIgnoreCase(code)) continue;
            types.add(SoftwareType.Mobile_Ios);
        }
        return types;
    }

    protected String getHelpId(Element element) {
        Element help = BaseElementParser.getElement(element, "help");
        return BaseElementParser.getAttribute(help, "id");
    }

    protected int getGroupId(Element element) {
        String strid = BaseElementParser.getAttribute(element, "group-id");
        return strid != null ? Integer.parseInt(strid) : 0;
    }

    protected int getWidth(Element element) {
        String strid = BaseElementParser.getAttribute(element, "width");
        return strid != null ? Integer.parseInt(strid) : 0;
    }

    protected void prefillField(IdentityField f, Element element) throws ParseException {
        f.setHelpSoftwareTypeMap(this.getHelp(element));
        f.setHelpId(this.getHelpId(element));
        f.setId(BaseElementParser.getAttribute(element, "name"));
        f.setTitle(this.getTitle(element));
        f.setTitleId(BaseElementParser.getAttribute(element, "title-id"));
        f.setMessage(this.getMessage(element));
        f.setMessageId(BaseElementParser.getAttribute(element, "message-id"));
        f.setOnTop(BaseElementParser.getAttribute(element, "on-top"));
        f.setGroupId(this.getGroupId(element));
        f.setWidth(this.getWidth(element));
    }

    protected Validator checkValidator(Validator validator, String name, int params) throws ParseException {
        boolean changeId2;
        if (validator == null) {
            return null;
        }
        boolean changeId1 = ParserParams.hasFlag(params, 16) && "id1".equals(name);
        boolean bl = changeId2 = ParserParams.hasFlag(params, 32) && "id2".equals(name);
        if ((changeId1 || changeId2) && validator.validate("")) {
            return new AndValidator(new Validator[]{new NotEmptyValidator(), validator});
        }
        return validator;
    }

    protected int getMaxLen(Element element, String name, int params) throws ParseException {
        int len = Integer.parseInt(BaseElementParser.getAttribute(element, "max-len"));
        if (len <= 40) {
            return len;
        }
        if ("id1".equals(name)) {
            if (ParserParams.hasFlag(params, 64)) {
                throw new ParseException("Value 'id1' > 40 symbols");
            }
            return 40;
        }
        if ("id2".equals(name)) {
            if (ParserParams.hasFlag(params, 128)) {
                throw new ParseException("Value 'id2' > 40 symbols");
            }
            return 40;
        }
        return len;
    }

    protected void checkItemStore(ItemsStore sds, String name, int params) throws ParseException {
        if (!"id1".equals(name) && !"id2".equals(name)) {
            return;
        }
        for (SelectorItem item : sds.getItems()) {
            String value = item.getValue();
            if (value.length() <= 40) continue;
            if ("id1".equals(name)) {
                if (ParserParams.hasFlag(params, 64)) {
                    throw new ParseException("Selector item value > 40 symbols");
                }
                item.setValue(value.substring(0, 40));
            }
            if (!"id2".equals(name)) continue;
            if (ParserParams.hasFlag(params, 128)) {
                throw new ParseException("Selector item value > 40 symbols");
            }
            item.setValue(value.substring(0, 40));
        }
    }

    protected DateRange createDateRange(String from, String to, String def, String format) throws java.text.ParseException {
        if (this.checkIntValue(from) && this.checkIntValue(to) && this.checkIntValue(def)) {
            return new RelativeDateRange(this.getIntValue(from), this.getIntValue(to), this.getIntValue(def));
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return new AbsoluteDateRange(this.getDateValue(from, sdf), this.getDateValue(to, sdf), this.getDateValue(def, sdf));
    }

    private RelativeRangeValue getIntValue(String value) {
        if (value != null) {
            String lowerValue = value.toLowerCase();
            if (lowerValue.endsWith("m")) {
                String intValue = lowerValue.substring(0, lowerValue.length() - 1);
                int month = Integer.parseInt(intValue);
                return new RelativeRangeValue(month, 2);
            }
            if (lowerValue.endsWith("y")) {
                String intValue = lowerValue.substring(0, lowerValue.length() - 1);
                int year = Integer.parseInt(intValue);
                return new RelativeRangeValue(year, 1);
            }
            if (lowerValue.endsWith("d")) {
                lowerValue = lowerValue.substring(0, lowerValue.length() - 1);
            }
            int day = Integer.parseInt(lowerValue);
            return new RelativeRangeValue(day, 5);
        }
        return null;
    }

    private boolean checkIntValue(String value) {
        return value == null || value.matches("-?\\d{1,3}[d|m|y|D|M|Y]?");
    }

    private Date getDateValue(String value, SimpleDateFormat sdf) throws java.text.ParseException {
        return value == null ? null : sdf.parse(value);
    }

    protected Map<String, PrefillItem> loadPrefillItems(Element element) {
        Element pr = BaseElementParser.getElement(element, "prefill-items");
        HashMap<String, PrefillItem> prefill = null;
        if (pr != null) {
            prefill = new HashMap<String, PrefillItem>();
            for (Element item : BaseElementParser.getElements(pr, "item")) {
                prefill.put(BaseElementParser.getAttribute(item, "from"), new PrefillItem(BaseElementParser.getAttribute(item, "to"), BaseElementParser.getAttribute(item, "title")));
            }
        }
        return prefill;
    }

    protected int getOrientation(Element element) {
        String attribute = BaseElementParser.getAttribute(element, "orientation");
        if ("PORTRAIT".equalsIgnoreCase(attribute)) {
            return 1;
        }
        if ("LANDSCAPE".equalsIgnoreCase(attribute)) {
            return 2;
        }
        return 0;
    }

    protected static void toString(Node el) {
        DOMSource domSource = new DOMSource(el);
        StringWriter sw = null;
        try {
            Transformer transformer = TransformerFactory.newInstance().newTransformer();
            sw = new StringWriter();
            StreamResult sr = new StreamResult(sw);
            transformer.transform(domSource, sr);
            System.out.println(sw.toString());
        }
        catch (TransformerException ex) {
            System.out.println(ex.getMessage());
        }
    }
}

