/*
 * Decompiled with CFR 0.152.
 */
package plfx.util;

import java.net.URL;
import java.security.AccessController;
import javafx.fxml.FXMLLoader;
import javafx.scene.Parent;
import org.apache.log4j.Logger;
import plfx.Options;
import plfx.util.FXMLClassLoader;
import plfx.util.LoadTemplateException;
import plfx.util.TimeMeter;

public class ResourceLoader {
    private static final Logger log = Options.GUI;
    private static final ClassLoader cachingClassLoader = AccessController.doPrivileged(() -> new FXMLClassLoader(FXMLLoader.getDefaultClassLoader()));

    public static Parent load(URL template, Object controller) throws LoadTemplateException {
        log.info((Object)("Load resource: " + template));
        TimeMeter tm = new TimeMeter();
        try {
            FXMLLoader fxmlLoader = new FXMLLoader(template);
            fxmlLoader.setClassLoader(cachingClassLoader);
            fxmlLoader.setController(controller);
            Parent p = (Parent)fxmlLoader.load();
            log.info((Object)("Load time: " + tm.getIntervalMsAsStr()));
            return p;
        }
        catch (Throwable ex) {
            throw new LoadTemplateException("Error on loading template: " + template, ex);
        }
    }
}

