/*
 * Decompiled with CFR 0.152.
 */
package plfx.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Locale;
import java.util.Properties;
import java.util.Stack;
import org.apache.commons.io.IOUtils;
import plfx.skin.Skin;
import plfx.util.LocatorErrorListener;

public class Locator {
    public static final String GUI = "/gui/";
    public static final String SKIN = "/gui/skin/";
    public static final String WORK_SKIN = "/gui/skin/{name}/";
    public static final String IMG = "/gui/skin/{name}/img/";
    public static final String CARDS = "/gui/skin/{name}/img/card/";
    public static final String CSS = "/gui/skin/{name}/css/";
    public static final String CSS_MENU = "/gui/skin/{name}/css/menu.css";
    public static final String SCALE_PROFILES = "/gui/skin/{name}/scale/profiles.properties";
    public static final String POPUP_DIALOG_SKIN = "/gui/skin/{name}/popup/dialog/";
    public static final String POPUP_DIALOG_SYS = "/gui/popup/dialog/";
    public static final String POPUP_WAIT = "/gui/popup/wait/mapping.properties";
    public static final String LAUNCH_ERROR = "/gui/system/error/";
    public static final String COMM_TPL_SYS = "/plfx/i18n/comm";
    public static final String PAYS_TPL_SYS = "/plfx/i18n/pays";
    public static final String CURR_TPL_SYS = "/plfx/i18n/currency/";
    public static final String COMM_TPL_SKIN = "/gui/skin/{name}/i18n/comm/";
    public static final String PAYS_TPL_SKIN = "/gui/skin/{name}/i18n/pays/";
    public static final String CURR_TPL_SKIN = "/gui/skin/{name}/i18n/currency/";
    public static final String SYSTEM = "/gui/system/";
    public static final String SYSTEM_CALIB = "/gui/system/calib/";
    public static final String SYSTEM_CONSOLE = "/gui/system/console/";
    public static final String SYSTEM_SCREEN = "/gui/system/screen/";
    private static LocatorErrorListener listener;

    public static void setListener(LocatorErrorListener listener) {
        Locator.listener = listener;
    }

    public static InputStream getInputStream(String path) {
        if (path == null) {
            return null;
        }
        InputStream is = Locator.class.getResourceAsStream(Locator.processPath(path));
        if (is == null) {
            try {
                return new FileInputStream(new File(".", path));
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
        return is;
    }

    public static InputStream getInputStream(String path, Locale locale) {
        if (path == null) {
            return null;
        }
        if (locale == null) {
            return null;
        }
        InputStream is = Locator.class.getResourceAsStream((path = Locator.processPath(path)).replace("{0}", "_" + locale.getLanguage() + "_" + locale.getCountry()));
        if (is == null && (is = Locator.class.getResourceAsStream(path.replace("{0}", "_" + locale.getLanguage()))) == null) {
            is = Locator.class.getResourceAsStream(path.replace("{0}", ""));
        }
        return is;
    }

    public static String getPath(String path) {
        URL url = Locator.getUrl(path);
        return url == null ? null : url.toExternalForm();
    }

    public static URL getUrl(String path) {
        return Locator.getUrl(path, true);
    }

    public static URL getUrl(String path, boolean notifyError) {
        if (path == null) {
            return null;
        }
        URL url = Locator.createUrl(path, false);
        if (url == null && notifyError) {
            Locator.notify(path, Locator.processPath(path));
        }
        return url;
    }

    public static URL getFileUrl(String path) {
        return Locator.getFileUrl(path, true);
    }

    public static URL getFileUrl(String path, boolean notifyError) {
        if (path == null) {
            return null;
        }
        URL url = Locator.createUrl(path, true);
        if (url == null && notifyError) {
            Locator.notify(path, Locator.processPath(path));
        }
        return url;
    }

    private static URL createUrl(String path, boolean filePriority) {
        return Locator.createUrl(path, filePriority, Skin.getAllSkins(), 1);
    }

    private static URL createUrl(String path, boolean filePriority, Stack<String> skins, int skinShift) {
        String fullPath = Locator.processPath(path, (String)skins.elementAt(skins.size() - skinShift));
        URL url = Locator.class.getResource(fullPath);
        URL fileUrl = null;
        File f = new File(".", fullPath);
        if (f.canRead()) {
            try {
                fileUrl = f.toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        if (url == null && fileUrl == null && skins.size() > skinShift && Locator.isImage(fullPath)) {
            url = Locator.createUrl(path, filePriority, skins, skinShift + 1);
        }
        if (filePriority) {
            return fileUrl != null ? fileUrl : url;
        }
        return url != null ? url : fileUrl;
    }

    private static boolean isImage(String filePath) {
        return filePath.endsWith(".png") || filePath.endsWith(".jpg") || filePath.endsWith(".gif");
    }

    public static Properties read(String path) throws IOException {
        return Locator.read(path, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties read(String path, boolean notifyError) throws IOException {
        URL url = Locator.getFileUrl(path, notifyError);
        if (url == null) {
            throw new IOException("File '" + path + "' is not found");
        }
        InputStream is = null;
        try {
            is = url.openStream();
            Properties prop = new Properties();
            prop.load(is);
            Properties properties = prop;
            return properties;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    public static Properties readQuietly(String path) {
        return Locator.readQuietly(path, true);
    }

    public static Properties readQuietly(String path, boolean notifyError) {
        try {
            return Locator.read(path, notifyError);
        }
        catch (IOException ex) {
            return new Properties();
        }
    }

    public static String processPath(String path) {
        return path.replace("{name}", Skin.getWorkSkin()).replace("//", "/");
    }

    public static String processPath(String path, String skin) {
        return path.replace("{name}", skin).replace("//", "/");
    }

    private static void notify(String id, String path) {
        if (listener != null) {
            listener.onMissingResource(id, path);
        }
    }
}

