/*
 * Decompiled with CFR 0.152.
 */
package plfx.util;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import plfx.Options;

public abstract class Cache2<K, T> {
    private final Logger log = Options.GUI;
    private final Map<K, SoftReference<T>> cache = new HashMap<K, SoftReference<T>>();

    public synchronized T getObject(K id) {
        if (id == null) {
            return null;
        }
        SoftReference<T> sri = this.cache.get(id);
        if (sri == null) {
            if (this.cache.containsKey(id)) {
                this.log.debug((Object)("Object is not exist: " + id));
                return null;
            }
            return this.loadObject(id);
        }
        T im = sri.get();
        if (im == null) {
            return this.loadObject(id);
        }
        this.log.debug((Object)("Load from cache: " + id));
        return im;
    }

    private T loadObject(K id) {
        T t = this.load(id);
        if (t != null) {
            this.cache.put(id, new SoftReference<T>(t));
        } else {
            this.cache.put(id, null);
        }
        return t;
    }

    protected abstract T load(K var1);
}

