/*
 * Decompiled with CFR 0.152.
 */
package plfx.util;

import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import plfx.Options;

public abstract class Cache<T> {
    protected Logger log = Options.GUI;
    private final Map<String, SoftReference<T>> cache = new HashMap<String, SoftReference<T>>();

    public synchronized T getObject(String path) {
        if (path == null) {
            return null;
        }
        SoftReference<T> sri = this.cache.get(path);
        if (sri == null) {
            if (this.cache.containsKey(path)) {
                this.log.debug((Object)("Object is not exist: " + path));
                return null;
            }
            return this.loadObject(path);
        }
        T im = sri.get();
        if (im == null) {
            return this.loadObject(path);
        }
        this.log.debug((Object)("Load from cache: " + path));
        return im;
    }

    private T loadObject(String path) {
        T t = this.load(path);
        if (t != null) {
            this.cache.put(path, new SoftReference<T>(t));
        } else {
            this.cache.put(path, null);
        }
        return t;
    }

    protected abstract T load(String var1);
}

