/*
 * Decompiled with CFR 0.152.
 */
package plfx.skin;

import java.net.URL;
import java.util.List;
import java.util.Map;
import plfx.skin.Resolution;
import plfx.skin.SkinProperties;
import plfx.util.Locator;

class SkinPropertiesImpl
implements SkinProperties {
    private final Resolution defaultResolution;
    private final float defaultFontBase;
    private final Map<String, Float> sizes;
    private final boolean usePreloading;
    private final boolean preloadSearch;
    private final List<String> menuLayers;
    private final List<String> commonLayers;
    private final List<String> dialogLayers;
    private final String version;

    public SkinPropertiesImpl(String name, Resolution defaultResolution, float defaultFontBase, Map<String, Float> sizes, boolean usePreloading, List<String> menuLayers, List<String> commonLayers, List<String> dialogLayers, String version) {
        this(name, defaultResolution, defaultFontBase, sizes, usePreloading, false, menuLayers, commonLayers, dialogLayers, version);
    }

    public SkinPropertiesImpl(String name, Resolution defaultResolution, float defaultFontBase, Map<String, Float> sizes, boolean usePreloading, boolean preloadSeach, List<String> menuLayers, List<String> commonLayers, List<String> dialogLayers, String version) {
        if (name == null || name.isEmpty()) {
            throw new NullPointerException("Name is wrong");
        }
        if (defaultResolution == null) {
            throw new NullPointerException("Default resolution is not set");
        }
        if (defaultFontBase < 1.0f || defaultFontBase > 99.0f) {
            throw new NullPointerException("DefaultFontBase must be in range 1..99");
        }
        if (sizes == null) {
            throw new NullPointerException("Needs for var sizes");
        }
        this.defaultResolution = defaultResolution;
        this.defaultFontBase = defaultFontBase;
        this.sizes = sizes;
        this.usePreloading = usePreloading;
        this.menuLayers = menuLayers;
        this.commonLayers = commonLayers;
        this.dialogLayers = dialogLayers;
        this.version = version;
        this.preloadSearch = preloadSeach;
    }

    @Override
    public Resolution getDefaultResolution() {
        return this.defaultResolution;
    }

    @Override
    public float getFontSize(Resolution resolution) {
        if (resolution == null) {
            throw new NullPointerException();
        }
        String resStr = resolution.getWidth() + "x" + resolution.getHeight();
        Float value = this.sizes.get(resStr);
        if (value != null) {
            return value.floatValue();
        }
        return (float)resolution.getHeight() * this.defaultFontBase / (float)this.defaultResolution.getHeight();
    }

    @Override
    public String getBaseStyleSheet(Resolution resolution) {
        if (resolution == null) {
            throw new NullPointerException("Resolution must be specify");
        }
        URL url = Locator.getFileUrl("/gui/skin/{name}//system/" + resolution.getWidth() + "x" + resolution.getHeight() + ".css");
        if (url != null) {
            return url.toExternalForm();
        }
        return null;
    }

    @Override
    public String getDefaultStyleSheet() {
        URL url = Locator.getFileUrl("/gui/skin/{name}//system/default.css");
        if (url != null) {
            return url.toExternalForm();
        }
        return null;
    }

    @Override
    public boolean isUsePreloading() {
        return this.usePreloading;
    }

    @Override
    public List<String> getPreloadingMenuLayers() {
        return this.menuLayers;
    }

    @Override
    public List<String> getPreloadingCommonLayers() {
        return this.commonLayers;
    }

    @Override
    public List<String> getPreloadingDialogLayers() {
        return this.dialogLayers;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public boolean isPreloadSearch() {
        return this.preloadSearch;
    }
}

