/*
 * Decompiled with CFR 0.152.
 */
package plfx.skin;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;
import org.apache.commons.io.IOUtils;
import plfx.msg.MessageProcessor;
import plfx.skin.Resolution;
import plfx.skin.SkinException;
import plfx.skin.SkinProperties;
import plfx.skin.SkinPropertiesImpl;
import plfx.skin.SkinSet;
import plfx.util.Locator;

public class Skin {
    private static final Stack<String> workSkins = new Stack();
    private static String workColorScheme;
    private static SkinSet skinSet;
    private static String workScreenSizeName;
    private static final Map<String, SkinProperties> props;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static synchronized SkinSet getSkinSet() throws SkinException {
        if (skinSet == null) {
            LinkedList<String> res = new LinkedList<String>();
            try {
                Enumeration<URL> resources = Skin.class.getClassLoader().getResources("gui/skin/skin.properties");
                while (resources.hasMoreElements()) {
                    InputStream is = null;
                    try {
                        is = resources.nextElement().openStream();
                        Properties prop = new Properties();
                        prop.load(is);
                        String name = prop.getProperty("name");
                        if (name != null && !name.isEmpty()) {
                            res.add(name);
                        }
                    }
                    catch (IOException iOException) {
                        IOUtils.closeQuietly(is);
                        continue;
                    }
                    catch (Throwable throwable) {
                        IOUtils.closeQuietly(is);
                        throw throwable;
                    }
                    IOUtils.closeQuietly((InputStream)is);
                }
            }
            catch (IOException ex) {
                throw new SkinException("Error on read skin names", ex);
            }
            if (res.isEmpty()) {
                throw new SkinException("Skins is not found");
            }
            String def = null;
            try {
                Properties prop = Locator.read("/gui/skin//default.properties", false);
                def = prop.getProperty("default-skin");
            }
            catch (IOException prop) {
                // empty catch block
            }
            if (def == null || def.isEmpty() || !res.contains(def)) {
                def = (String)res.get(0);
            }
            HashSet<String> set = new HashSet<String>();
            set.addAll(res);
            skinSet = new SkinSet(def, Collections.unmodifiableSet(set));
        }
        return skinSet;
    }

    public static String getWorkSkin() {
        if (workSkins.size() > 0) {
            return workSkins.peek();
        }
        return null;
    }

    public static Stack<String> getAllSkins() {
        return workSkins;
    }

    public static void setWorkSkin(String workSkin) {
        workSkins.clear();
        workSkins.push(workSkin);
        Skin.setBundle();
    }

    public static void pushWorkSkin(String workSkin) {
        workSkins.push(workSkin);
        Skin.setBundle();
    }

    public static String popWorkSkin() {
        String skin = null;
        if (workSkins.size() > 1) {
            skin = workSkins.pop();
            Skin.setBundle();
        }
        return skin;
    }

    private static void setBundle() {
        MessageProcessor.setBundle("skin", "gui.skin." + workSkins.peek() + ".i18n.skin");
        MessageProcessor.setBundle("skin_dlg", "gui.skin." + workSkins.peek() + ".i18n.dialog.dialog");
    }

    public static String getWorkColorScheme() {
        return workColorScheme;
    }

    public static void setWorkColorScheme(String workColorScheme) {
        Skin.workColorScheme = workColorScheme;
    }

    public static synchronized SkinProperties readProperties(String name) throws SkinException {
        SkinProperties sp = props.get(name);
        if (sp == null) {
            try {
                Properties prop = Locator.read("/gui/skin/" + name + "/options.properties");
                String version = prop.getProperty("version");
                String resDefStr = prop.getProperty("resolution.default");
                if (resDefStr == null || resDefStr.isEmpty()) {
                    throw new SkinException("Key 'resolution.default' is not found or wrong");
                }
                Resolution defaultResolution = Skin.convert(resDefStr);
                String fontSizeDefStr = prop.getProperty("font-base." + resDefStr);
                if (fontSizeDefStr == null || fontSizeDefStr.isEmpty()) {
                    throw new SkinException("Key 'font-base." + resDefStr + "' is not found or wrong.");
                }
                float fontSizeDef = Float.parseFloat(fontSizeDefStr);
                if (fontSizeDef < 1.0f) {
                    throw new SkinException("Value must be in range [1..100]");
                }
                HashMap<String, Float> sizes = new HashMap<String, Float>();
                for (String key : prop.stringPropertyNames()) {
                    if (!key.startsWith("font-base")) continue;
                    String value = prop.getProperty(key);
                    sizes.put(key.substring(10), Float.valueOf(Float.parseFloat(value)));
                }
                boolean usePreloading = Boolean.parseBoolean(prop.getProperty("preloading", "false"));
                boolean preloadSearch = Boolean.parseBoolean(prop.getProperty("preloading.search", "false"));
                List<String> menuLayers = Arrays.asList(prop.getProperty("preloading.menu", "").split(","));
                List<String> commonLayers = Arrays.asList(prop.getProperty("preloading.common", "").split(","));
                List<String> dialogLayers = Arrays.asList(prop.getProperty("preloading.dialog", "").split(","));
                sp = new SkinPropertiesImpl(name, defaultResolution, fontSizeDef, sizes, usePreloading, preloadSearch, menuLayers, commonLayers, dialogLayers, version);
                props.put(name, sp);
            }
            catch (IOException | NumberFormatException ex) {
                throw new SkinException(ex);
            }
        }
        return sp;
    }

    private static Resolution convert(String resStr) throws SkinException {
        String[] paths = resStr.split("x");
        if (paths.length != 2) {
            throw new SkinException("Wrong resolution format: " + resStr + ", example 1280x1024");
        }
        if (!paths[0].matches("^\\d{3,4}$")) {
            throw new SkinException("Wrong resolution width: " + resStr + ", example 1280x1024");
        }
        if (!paths[1].matches("^\\d{3,4}$")) {
            throw new SkinException("Wrong resolution height: " + resStr + ", example 1280x1024");
        }
        return new Resolution(Integer.parseInt(paths[0]), Integer.parseInt(paths[1]));
    }

    public static boolean isExistColorScheme(String name) {
        if (name == null) {
            return true;
        }
        name = name.endsWith(".css") ? name : name + ".css";
        return Locator.getUrl("/gui/skin/{name}/css/" + name) != null;
    }

    public static boolean isExistSkin(String name) {
        try {
            Skin.readProperties(name);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public static String getWorkScreenSizeName() {
        return workScreenSizeName;
    }

    public static void setWorkScreenSizeName(String workScreenSize) {
        workScreenSizeName = workScreenSize;
    }

    static {
        workScreenSizeName = "default";
        props = new HashMap<String, SkinProperties>();
        workSkins.push("default");
    }
}

