/*
 * Decompiled with CFR 0.152.
 */
package plfx.shell2.wait;

import org.apache.log4j.Logger;
import plfx.Options;
import plfx.msg.screen.ScreenProcessor;
import plfx.screen.popup.wait.WaitTemplate;
import plfx.screen.popup.wait.WaitTemplateStore;
import plfx.shell.BannerProcessor;
import plfx.shell.BaseShellLayer;
import plfx.shell.LayerType;
import plfx.shell.Shell;
import plfx.shell.ShellControl;
import plfx.shell.ShellLayer;
import plfx.shell2.wait.BaseWaitControl;
import plfx.shell2.wait.WaitControl;
import plfx.shell2.wait.WaitModule;

public class BaseWaitModule
implements WaitModule {
    private final ShellLayer container;
    private final Logger log = Options.DEBUG;
    private final BannerProcessor bannerProcessor;

    public BaseWaitModule(Shell shell, BannerProcessor bannerProcessor) {
        if (shell == null) {
            throw new NullPointerException("Shell");
        }
        this.container = new BaseShellLayer(shell, LayerType.Dialog, "** wait **");
        this.bannerProcessor = bannerProcessor;
    }

    @Override
    public WaitControl show(String waitId) {
        this.log.info((Object)("Show wait, id=" + waitId));
        WaitTemplate wt = WaitTemplateStore.getTemplate(waitId);
        wt.setMessage(waitId);
        wt.setId(waitId);
        ScreenProcessor.process(wt, wt.getDefaultBundle());
        this.bannerProcessor.process(wt);
        ShellControl sc = this.container.show(wt.getPane());
        sc.visibleProperty().addListener((observable, oldValue, newValue) -> wt.setVisible((boolean)newValue));
        sc.show();
        return new BaseWaitControl(sc, waitId);
    }
}

