/*
 * Decompiled with CFR 0.152.
 */
package plfx.shell2.dialog;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.log4j.Logger;
import plfx.Options;
import plfx.element.DateSLabel;
import plfx.element.SLabel;
import plfx.screen.popup.dialog.DialogTemplate;
import plfx.shell2.dialog.DialogListener;
import plfx.shell2.timer.TimerEntity;
import plfx.util.TerminalPlatform;

class DialogTimerEntity
implements TimerEntity {
    private final String dialogId;
    private final int actionId;
    private final int timeout;
    private final DialogTemplate template;
    private DialogListener listener;
    private int current;
    private boolean complete;
    private final Logger log = Options.GUI;

    public DialogTimerEntity(String dialogId, int actionId, int timeout, DialogTemplate template) {
        this.dialogId = dialogId;
        this.actionId = actionId;
        this.timeout = timeout >= 3 ? timeout : 5;
        this.template = template;
        TerminalPlatform.runLater(new FxUpdateRunner());
    }

    @Override
    public boolean process(int sec) {
        if (this.complete) {
            return true;
        }
        ++this.current;
        TerminalPlatform.runLater(new FxUpdateRunner());
        if (this.current > this.timeout) {
            this.complete = true;
            TerminalPlatform.runLater(new FxActionRunner());
        }
        return this.complete;
    }

    public void complete() {
        this.complete = true;
    }

    public void setListener(DialogListener listener) {
        this.listener = listener;
    }

    public String toString() {
        return "DialogTimerEntity{dialogId=" + this.dialogId + ", actionId=" + this.actionId + ", timeout=" + this.timeout + ", current=" + this.current + ", complete=" + this.complete + '}';
    }

    private class FxUpdateRunner
    implements Runnable {
        private FxUpdateRunner() {
        }

        @Override
        public void run() {
            for (SLabel timer : DialogTimerEntity.this.template.getTimers()) {
                timer.setText(String.format("%02d:%02d", (DialogTimerEntity.this.timeout - DialogTimerEntity.this.current) / 60, (DialogTimerEntity.this.timeout - DialogTimerEntity.this.current) % 60));
            }
            for (DateSLabel date : DialogTimerEntity.this.template.getDates()) {
                date.setText(new SimpleDateFormat(date.getFormat()).format(Calendar.getInstance().getTime()));
            }
            DialogTimerEntity.this.template.getProgressIndicator().setProgress((double)DialogTimerEntity.this.current * 1.0 / (double)DialogTimerEntity.this.timeout);
            DialogTimerEntity.this.template.getTimeoutLabel().setText(Integer.toString(DialogTimerEntity.this.timeout - DialogTimerEntity.this.current));
        }
    }

    private class FxActionRunner
    implements Runnable {
        private FxActionRunner() {
        }

        @Override
        public void run() {
            DialogTimerEntity.this.log.info((Object)"---> Timer fire action");
            DialogTimerEntity.this.listener.onAction(DialogTimerEntity.this.actionId);
        }
    }
}

