/*
 * Decompiled with CFR 0.152.
 */
package plfx.shell2.dialog;

import org.apache.log4j.Logger;
import plfx.Options;
import plfx.shell.ShellControl;
import plfx.shell2.dialog.DialogListener;
import plfx.shell2.dialog.DialogTimerEntity;

class DialogHandler
implements DialogListener {
    private final String dialogId;
    private final DialogListener parent;
    private final ShellControl control;
    private final DialogTimerEntity entity;
    private static final Logger log = Options.GUI;
    private boolean fired = false;

    public DialogHandler(String dialogId, DialogListener parent, ShellControl control, DialogTimerEntity entity) {
        if (dialogId == null) {
            throw new NullPointerException("DialogId");
        }
        if (parent == null) {
            throw new NullPointerException("DialogListener");
        }
        if (control == null) {
            throw new NullPointerException("ShellControl");
        }
        if (entity == null) {
            throw new NullPointerException("DialogTimerEntity");
        }
        this.dialogId = dialogId;
        this.parent = parent;
        this.control = control;
        this.entity = entity;
    }

    @Override
    public synchronized void onAction(int actionId) {
        log.info((Object)("Dialog: " + this.dialogId + ", actionId: " + actionId));
        if (!this.fired) {
            log.info((Object)"Process action");
            this.fired = true;
            log.info((Object)"Hide dialog");
            this.control.hide();
            this.entity.complete();
            this.parent.onAction(actionId);
        } else {
            log.info((Object)"Action already complete");
        }
    }
}

