/*
 * Decompiled with CFR 0.152.
 */
package plfx.shell2.dialog;

import javafx.application.Platform;
import plfx.screen.popup.dialog.DialogDescriptor;
import plfx.shell.BaseShellLayer;
import plfx.shell.ShellLayer;
import plfx.shell2.dialog.DialogCore;
import plfx.shell2.dialog.DialogListener;
import plfx.shell2.dialog.DialogListenerStub;
import plfx.shell2.dialog.DialogModule;
import plfx.shell2.dialog.SyncDialogListener;
import plfx.util.TerminalPlatform;

public class BaseDialogModule
implements DialogModule {
    private final DialogCore core;
    private final ShellLayer container;

    public BaseDialogModule(DialogCore core, BaseShellLayer layer) {
        if (core == null) {
            throw new NullPointerException("DialogCore");
        }
        if (layer == null) {
            throw new NullPointerException("PaneContainer");
        }
        this.core = core;
        this.container = layer;
    }

    @Override
    public void show(String dialogId) {
        this.show(dialogId, (DialogListener)new DialogListenerStub());
    }

    @Override
    public void show(String dialogId, DialogListener listener) {
        this.core.show(dialogId, listener, this.container);
    }

    @Override
    public void show(DialogDescriptor descriptor, DialogListener listener) {
        this.core.show(descriptor, listener, this.container);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int showAndWait(String dialogId) {
        if (Platform.isFxApplicationThread()) {
            throw new IllegalStateException("Using from fx thread");
        }
        SyncDialogListener listener = new SyncDialogListener();
        TerminalPlatform.runLater(new FxRunner(dialogId, listener));
        try {
            SyncDialogListener syncDialogListener = listener;
            synchronized (syncDialogListener) {
                listener.wait();
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
        return listener.getActionId();
    }

    private class FxRunner
    implements Runnable {
        private final String dialogId;
        private final DialogListener listener;

        public FxRunner(String dialogId, DialogListener listener) {
            this.dialogId = dialogId;
            this.listener = listener;
        }

        @Override
        public void run() {
            BaseDialogModule.this.show(this.dialogId, this.listener);
        }
    }
}

