/*
 * Decompiled with CFR 0.152.
 */
package plfx.shell2.dialog;

import org.apache.log4j.Logger;
import plfx.Options;
import plfx.element.FxInitException;
import plfx.element.SButton;
import plfx.msg.screen.ScreenProcessor;
import plfx.screen.ScreenStore;
import plfx.screen.popup.dialog.DialogButton;
import plfx.screen.popup.dialog.DialogDescriptor;
import plfx.screen.popup.dialog.DialogDescriptorNotFoundException;
import plfx.screen.popup.dialog.DialogDescriptorStore;
import plfx.screen.popup.dialog.DialogTemplate;
import plfx.shell.BannerProcessor;
import plfx.shell.ShellControl;
import plfx.shell.ShellLayer;
import plfx.shell2.dialog.ButtonHandler;
import plfx.shell2.dialog.DialogCore;
import plfx.shell2.dialog.DialogErrorListener;
import plfx.shell2.dialog.DialogHandler;
import plfx.shell2.dialog.DialogListener;
import plfx.shell2.dialog.DialogMessageTemplate;
import plfx.shell2.dialog.DialogTimerEntity;
import plfx.shell2.timer.Timer;
import plfx.util.LoadTemplateException;
import plfx.util.TerminalPlatform;

public class BaseDialogCore
implements DialogCore {
    private final Timer timer;
    private final DialogErrorListener errorListener;
    private final DialogDescriptorStore descriptorStore;
    private final Logger log = Options.DEBUG;
    private final BannerProcessor bannerProcessor;

    public BaseDialogCore(Timer timer, DialogErrorListener errorListener, BannerProcessor bannerProcessor) {
        if (timer == null) {
            throw new NullPointerException("Timer");
        }
        if (errorListener == null) {
            throw new NullPointerException("DialogErrorListener");
        }
        if (bannerProcessor == null) {
            throw new NullPointerException("BannerProcessor");
        }
        this.timer = timer;
        this.errorListener = errorListener;
        this.descriptorStore = new DialogDescriptorStore();
        this.bannerProcessor = bannerProcessor;
    }

    @Override
    public void show(String dialogId, DialogListener listener, ShellLayer container) {
        if (dialogId == null) {
            throw new NullPointerException("DialogId is not set");
        }
        if (listener == null) {
            throw new NullPointerException("DialogListener is not set");
        }
        if (container == null) {
            throw new NullPointerException("PaneContainer is not set");
        }
        try {
            this.log.info((Object)"Load dialog descriptor");
            DialogDescriptor dd = this.descriptorStore.getDescriptor(dialogId);
            this.log.info((Object)"Complete");
            this.show(dd, dialogId, listener, container);
        }
        catch (DialogDescriptorNotFoundException ex) {
            this.log.info((Object)"Can't create dialog descriptor", (Throwable)ex);
            this.errorListener.onDescriptionError(ex);
        }
        catch (Throwable ex) {
            this.log.info((Object)"Unknown error on show dialog", ex);
            this.errorListener.onTemplateError(new Exception(ex));
        }
    }

    @Override
    public void show(DialogDescriptor descriptor, DialogListener listener, ShellLayer container) {
        if (descriptor == null) {
            throw new NullPointerException("DialogDescriptor is not set");
        }
        if (listener == null) {
            throw new NullPointerException("DialogListener is not set");
        }
        if (container == null) {
            throw new NullPointerException("PaneContainer is not set");
        }
        this.show(descriptor, "-", listener, container);
    }

    private void show(DialogDescriptor dd, String dialogId, DialogListener listener, ShellLayer container) {
        try {
            if (dd.getTimeout() <= 0) {
                this.log.info((Object)("Timeout is 0. Skipping show dialog: " + dialogId));
                TerminalPlatform.runLater(() -> listener.onAction(dd.getDefaultActionId()));
                return;
            }
            this.log.info((Object)("Load dialog template: " + dialogId));
            DialogTemplate dt = ScreenStore.getDialogTemplate(dd.getTemplate());
            dt.getIdentificationLabel().setText(dialogId);
            this.log.info((Object)"Complete");
            String style = dd.getStyle() != null && !dd.getStyle().isEmpty() ? dd.getStyle() : "warning";
            this.log.info((Object)("Set dialog style: " + style));
            dt.setStyle(style);
            if (dd.getButtons().length != dt.getActionButtons().size()) {
                throw new FxInitException("The number of buttons does not meet the required. Desc count: " + dd.getButtons().length + ", template count: " + dt.getActionButtons().size());
            }
            this.log.debug((Object)("Description: " + dd));
            DialogMessageTemplate dmt = new DialogMessageTemplate(dd.getMessage());
            ScreenProcessor.process(dd.isSkinBundle() ? "skin_dlg" : "dlg", dmt);
            dt.getMessageLabel().setText(dmt.getValue().replace("<br>", "\n").replace("<br/>", "\n").replaceAll("<[^>]*>", ""));
            dmt = new DialogMessageTemplate(dd.getTitle());
            ScreenProcessor.process(dd.isSkinBundle() ? "skin_dlg" : "dlg", dmt);
            dt.getTitleLabel().setText(dmt.getValue());
            dmt = new DialogMessageTemplate(dd.getTitle());
            ScreenProcessor.process(dd.isSkinBundle() ? "skin_dlg" : "dlg", dmt);
            dt.getTitleLabel().setText(dmt.getValue());
            this.log.debug((Object)("Dialog button size: " + dt.getActionButtons().size()));
            for (SButton sButton : dt.getActionButtons()) {
                sButton.setText("");
                sButton.setListener(null);
            }
            ShellControl control = container.show(dt.getPane());
            DialogTimerEntity dialogTimerEntity = new DialogTimerEntity(dialogId, dd.getDefaultActionId(), dd.getTimeout(), dt);
            DialogHandler handler = new DialogHandler(dialogId, listener, control, dialogTimerEntity);
            dialogTimerEntity.setListener(handler);
            dt.getActionButtons().forEach(b -> b.setDisable(true));
            for (int i = 0; i < dt.getActionButtons().size() && i < dd.getButtons().length; ++i) {
                SButton sb = dt.getActionButtons().get(i);
                sb.setDisable(false);
                DialogButton db = dd.getButtons()[i];
                sb.setListener(new ButtonHandler(db.getActionId(), handler));
                if (db.getStyle() != null && !db.getStyle().isEmpty()) {
                    sb.getNode().getStyleClass().add((Object)db.getStyle());
                } else {
                    sb.getNode().getStyleClass().add((Object)"simple-button");
                }
                dmt = new DialogMessageTemplate(db.getTitle());
                ScreenProcessor.process(dd.isSkinBundle() ? "skin_dlg" : "dlg", dmt);
                sb.setText(dmt.getValue());
                dmt = new DialogMessageTemplate(db.getHint());
                ScreenProcessor.process(dd.isSkinBundle() ? "skin_dlg" : "dlg", dmt);
                sb.setHint(dmt.getValue());
            }
            ScreenProcessor.process("skin_dlg", dt.getElements());
            this.bannerProcessor.process(dt);
            control.show();
            this.timer.addEntity(dialogTimerEntity);
        }
        catch (FxInitException | LoadTemplateException ex) {
            this.log.info((Object)"Can't create dialog template", (Throwable)ex);
            this.errorListener.onTemplateError(ex);
        }
        catch (Throwable ex) {
            this.log.info((Object)"Unknown error on show dialog", ex);
            this.errorListener.onTemplateError(new Exception(ex));
        }
    }
}

