/*
 * Decompiled with CFR 0.152.
 */
package plfx.shell.popup;

import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import plfx.msg.screen.ScreenProcessor;
import plfx.screen.CommonScreen;
import plfx.screen.FxScreenTemplate;
import plfx.screen.ScreenListener;
import plfx.shell.BannerProcessor;
import plfx.shell.BaseShellLayer;
import plfx.shell.LayerType;
import plfx.shell.Shell;
import plfx.shell.ShellControl;
import plfx.shell.ShellLayer;
import plfx.shell.custom.CustomTimerEntity;
import plfx.shell.custom.DefaultHandler;
import plfx.shell.custom.Handler;
import plfx.shell.custom.ScreenHandler;
import plfx.shell.custom.TimeoutAdapter;
import plfx.shell.custom.TimeoutListener;
import plfx.shell.popup.PopupModule;
import plfx.shell2.timer.Timer;

public class DefaultPopupModule
implements PopupModule {
    private final Timer timer;
    private final ShellLayer container;
    private final BannerProcessor bannerProcessor;

    public DefaultPopupModule(Timer timer, Shell shell, BannerProcessor bannerProcessor) {
        if (timer == null) {
            throw new NullPointerException("Timer");
        }
        if (shell == null) {
            throw new NullPointerException("Shell");
        }
        if (bannerProcessor == null) {
            throw new NullPointerException("BannerProcessor");
        }
        this.timer = timer;
        this.container = new BaseShellLayer(shell, LayerType.Popup, "** popup **");
        this.bannerProcessor = bannerProcessor;
    }

    @Override
    public void show(CommonScreen screen, ScreenListener listener, int timeout) {
        if (screen == null) {
            throw new NullPointerException("CommonScreen is not set");
        }
        if (listener == null) {
            throw new NullPointerException("ScreenListener is not set");
        }
        ScreenProcessor.process(screen.getTemplate(), screen.getTemplate().getDefaultBundle());
        this.bannerProcessor.process(screen.getTemplate());
        ShellControl sc = this.container.show(screen.getTemplate().getPane());
        sc.visibleProperty().addListener((ChangeListener)new ChangeListenerImpl(screen, sc));
        CustomTimerEntity cte = new CustomTimerEntity(screen.getTemplate(), timeout);
        ScreenHandler sh = new ScreenHandler(listener, sc, cte);
        screen.setListener(sh);
        cte.setListener(new TimeoutAdapter(sh));
        sc.show();
        screen.getTemplate().setVisible(true);
        this.timer.addEntity(cte);
    }

    @Override
    public Handler show(FxScreenTemplate template, TimeoutListener listener, int timeout) {
        if (template == null) {
            throw new NullPointerException("FxScreenTemplate is not set");
        }
        if (listener == null) {
            throw new NullPointerException("TimeoutListener is not set");
        }
        ScreenProcessor.process(template, template.getDefaultBundle());
        this.bannerProcessor.process(template);
        ShellControl sc = this.container.show(template.getPane());
        CustomTimerEntity cte = new CustomTimerEntity(template, timeout);
        cte.setListener(listener);
        sc.show();
        this.timer.addEntity(cte);
        return new DefaultHandler(sc, cte);
    }

    private static class ChangeListenerImpl
    implements ChangeListener<Boolean> {
        private final CommonScreen screen;
        private final ShellControl sc;

        public ChangeListenerImpl(CommonScreen screen, ShellControl sc) {
            this.screen = screen;
            this.sc = sc;
        }

        public void changed(ObservableValue<? extends Boolean> observable, Boolean oldValue, Boolean newValue) {
            this.screen.getTemplate().setVisible(newValue);
            if (!newValue.booleanValue()) {
                this.sc.visibleProperty().removeListener((ChangeListener)this);
            }
        }
    }
}

