/*
 * Decompiled with CFR 0.152.
 */
package plfx.shell.custom;

import java.util.Map;
import org.apache.log4j.Logger;
import plfx.GuiNotifier;
import plfx.Options;
import plfx.screen.CommonScreen;
import plfx.screen.ScreenCreateException;
import plfx.screen.ScreenInit;
import plfx.screen.ScreenListener;
import plfx.screen.ScreenStore;
import plfx.shell.ShellControl;
import plfx.shell.custom.CustomTimerEntity;
import ru.softlogic.input.model.field.InitException;
import ru.softlogic.input.model.screen.description.ScreenDescription;

public class ScreenHandler
implements ScreenListener {
    private ScreenListener parent;
    private ShellControl control;
    private CustomTimerEntity entity;
    private boolean fired = false;
    private final Logger log = Options.GUI;

    public ScreenHandler(ScreenListener parent, ShellControl control, CustomTimerEntity entity) {
        if (parent == null) {
            throw new NullPointerException("ScreenListener");
        }
        if (control == null) {
            throw new NullPointerException("ShellControl");
        }
        if (entity == null) {
            throw new NullPointerException("CustomTimerEntity");
        }
        this.parent = parent;
        this.control = control;
        this.entity = entity;
    }

    @Override
    public void onAction(String action, Map<String, Object> data, Runnable cancelListener) {
        this.log.info((Object)("Action: " + action));
        if (!this.fired) {
            this.log.info((Object)"Process action");
            this.fired = true;
            this.log.info((Object)"Hide custom screen");
            this.control.hide();
            this.entity.complete();
            this.parent.onAction(action, data, null);
        } else {
            this.log.info((Object)"Action already complete");
        }
    }

    @Override
    public void onSelectLang(String lang) {
    }

    @Override
    public void onSelectField(int index) {
    }

    @Override
    public void showPopup(ScreenDescription sd, ScreenInit si, ScreenListener listener) {
        this.log.info((Object)("Try to show popup: " + sd.getType()));
        try {
            CommonScreen cs = ScreenStore.getCommonScreen(sd.getType());
            if (cs != null) {
                cs.init(sd, si);
                this.parent.showPopup(sd, si, listener);
            } else {
                GuiNotifier.notifyError("Can't get screen for type: " + sd.getType());
            }
        }
        catch (ScreenCreateException | InitException ex) {
            GuiNotifier.notifyError(ex);
        }
    }

    @Override
    public void onNextLang() {
    }

    @Override
    public void setFieldPage(int index, int pageSize) {
    }

    @Override
    public void notifyUpdate() {
    }
}

