/*
 * Decompiled with CFR 0.152.
 */
package plfx.shell.custom;

import java.text.SimpleDateFormat;
import java.util.Calendar;
import org.apache.log4j.Logger;
import plfx.Options;
import plfx.element.DateSLabel;
import plfx.element.SLabel;
import plfx.screen.FxScreenTemplate;
import plfx.shell.custom.TimeoutListener;
import plfx.shell2.timer.TimerEntity;
import plfx.util.TerminalPlatform;

public class CustomTimerEntity
implements TimerEntity {
    private final FxScreenTemplate template;
    private final int timeout;
    private static final Logger log = Options.GUI;
    private int current;
    private boolean complete;
    private TimeoutListener listener;

    public CustomTimerEntity(FxScreenTemplate template, int timeout) {
        this.template = template;
        this.timeout = timeout > 10 ? timeout : 10;
        TerminalPlatform.runLater(new FxUpdateRunner());
    }

    @Override
    public boolean process(int sec) {
        if (this.complete) {
            return true;
        }
        this.current = sec;
        TerminalPlatform.runLater(new FxUpdateRunner());
        if (sec > this.timeout) {
            this.complete = true;
            TerminalPlatform.runLater(new FxActionRunner());
        }
        return this.complete;
    }

    public void complete() {
        this.complete = true;
    }

    public void setListener(TimeoutListener listener) {
        this.listener = listener;
    }

    public String toString() {
        return "CustomTimerEntity{timeout=" + this.timeout + ", current=" + this.current + ", complete=" + this.complete + '}';
    }

    private class FxUpdateRunner
    implements Runnable {
        private FxUpdateRunner() {
        }

        @Override
        public void run() {
            for (SLabel timer : CustomTimerEntity.this.template.getTimers()) {
                timer.setText(String.format("%02d:%02d", (CustomTimerEntity.this.timeout - CustomTimerEntity.this.current) / 60, (CustomTimerEntity.this.timeout - CustomTimerEntity.this.current) % 60));
            }
            for (DateSLabel date : CustomTimerEntity.this.template.getDates()) {
                date.setText(new SimpleDateFormat(date.getFormat()).format(Calendar.getInstance().getTime()));
            }
            CustomTimerEntity.this.template.getProgressIndicator().setProgress((double)CustomTimerEntity.this.current * 1.0 / (double)CustomTimerEntity.this.timeout);
            CustomTimerEntity.this.template.getTimeoutLabel().setText(Integer.toString(CustomTimerEntity.this.timeout - CustomTimerEntity.this.current));
        }
    }

    private class FxActionRunner
    implements Runnable {
        private FxActionRunner() {
        }

        @Override
        public void run() {
            log.info((Object)"---> Timer fire action");
            CustomTimerEntity.this.listener.onTimeout();
        }
    }
}

