/*
 * Decompiled with CFR 0.152.
 */
package plfx.shell;

import java.util.Properties;
import plfx.element.FxInitException;
import plfx.screen.ShellCreateException;
import plfx.shell.GridShell;
import plfx.shell.Shell;
import plfx.shell.ShellFactory;
import plfx.util.LoadTemplateException;
import plfx.util.Locator;
import plfx.util.ResourceLoader;

public class GridShellFactory
implements ShellFactory {
    @Override
    public Shell create(Properties prop) throws ShellCreateException {
        if (prop == null) {
            throw new ShellCreateException("Properties are not set");
        }
        String loc = prop.getProperty("location");
        if (loc == null || !loc.matches("\\d,\\d,\\d,\\d")) {
            throw new ShellCreateException("Location is not set or has wrong format");
        }
        try {
            String[] ls = loc.split(",");
            GridShell gs = new GridShell(Integer.parseInt(ls[0]), Integer.parseInt(ls[1]), Integer.parseInt(ls[2]), Integer.parseInt(ls[3]));
            ResourceLoader.load(Locator.getUrl("/gui/skin/{name}//shell/template.fxml"), gs);
            gs.init();
            return gs;
        }
        catch (FxInitException | LoadTemplateException ex) {
            throw new ShellCreateException("Error on create shell", ex);
        }
    }
}

