/*
 * Decompiled with CFR 0.152.
 */
package plfx.shell;

import java.util.HashMap;
import java.util.Map;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;
import javafx.scene.layout.StackPane;
import plfx.GuiNotifier;
import plfx.element.FxInitException;
import plfx.screen.BaseFxScreenTemplate;
import plfx.screen.FxScreenTemplate;
import plfx.shell.BaseShellControl;
import plfx.shell.LayerType;
import plfx.shell.Shell;
import plfx.shell.ShellControl;

class GridShell
extends BaseFxScreenTemplate
implements Shell {
    private FxScreenTemplate template;
    @FXML
    private GridPane content;
    private final int row;
    private final int col;
    private final int rowSpan;
    private final int colSpan;
    private final StackPane stackPane = new StackPane();
    private final Map<LayerType, AnchorPane> layers = new HashMap<LayerType, AnchorPane>();
    private final Region tmp;

    public GridShell(int row, int col, int rowSpan, int colSpan) {
        super("shell.grid", "skin");
        this.row = row;
        this.col = col;
        this.rowSpan = rowSpan;
        this.colSpan = colSpan;
        this.tmp = new Region();
    }

    @Override
    public void init() throws FxInitException {
        super.init();
        if (this.content == null) {
            throw new FxInitException("GridPane with ID=content is not found");
        }
        this.stackPane.getChildren().add((Object)this.rootPane);
        this.stackPane.getChildren().add((Object)this.createPopupPane(LayerType.Custom));
        this.stackPane.getChildren().add((Object)this.createPopupPane(LayerType.Popup));
        this.stackPane.getChildren().add((Object)this.createPopupPane(LayerType.Dialog));
        this.stackPane.getChildren().add((Object)this.createPopupPane(LayerType.System));
        this.stackPane.getStyleClass().add((Object)"base-panel");
    }

    @Override
    public ShellControl bind(Node node, LayerType layer, String id) {
        if (layer == null) {
            throw new NullPointerException("LayerType");
        }
        if (node == null) {
            throw new NullPointerException("Node");
        }
        return this.processLayer(this.layers.get((Object)layer), node, layer, id);
    }

    @Override
    public void showContent(FxScreenTemplate rootTemplate) {
        if (rootTemplate == null) {
            throw new NullPointerException();
        }
        if (this.template != null) {
            this.content.getChildren().removeAll((Object[])new Node[]{this.template.getPane()});
        }
        this.template = rootTemplate;
        this.content.add((Node)this.tmp, this.row, this.col, this.rowSpan, this.colSpan);
        this.content.getChildren().remove((Object)this.tmp);
        this.content.add((Node)this.template.getPane(), this.row, this.col, this.rowSpan, this.colSpan);
    }

    private ShellControl processLayer(AnchorPane pane, Node node, LayerType type, String id) {
        if (!pane.getChildren().isEmpty()) {
            GuiNotifier.notifyError("Show " + node + " on active layer " + (Object)((Object)type));
            pane.getChildren().clear();
        }
        AnchorPane.setTopAnchor((Node)node, (Double)0.0);
        AnchorPane.setBottomAnchor((Node)node, (Double)0.0);
        AnchorPane.setLeftAnchor((Node)node, (Double)0.0);
        AnchorPane.setRightAnchor((Node)node, (Double)0.0);
        pane.getChildren().add((Object)this.tmp);
        pane.getChildren().remove((Object)this.tmp);
        pane.getChildren().add((Object)node);
        return new BaseShellControl((Pane)pane, node, id);
    }

    private AnchorPane createPopupPane(LayerType type) {
        AnchorPane anchorPane = new AnchorPane();
        anchorPane.setVisible(false);
        this.layers.put(type, anchorPane);
        return anchorPane;
    }

    @Override
    public Pane getPane() {
        return this.stackPane;
    }

    @Override
    public void addBaseCss(String css) {
        if (css == null) {
            throw new NullPointerException("Css");
        }
        this.stackPane.getStylesheets().add((Object)css);
    }
}

