/*
 * Decompiled with CFR 0.152.
 */
package plfx.shell;

import java.util.HashSet;
import java.util.Set;
import plfx.msg.screen.ScreenProcessor;
import plfx.screen.FxScreenTemplate;
import plfx.shell.BannerProcessor;
import plfx.shell.ScreenModule;
import plfx.shell.Shell;
import plfx.shell.TemplateListener;

public class DefaultScreenModule
implements ScreenModule {
    private final Shell shell;
    private final BannerProcessor bannerProcessor;
    private FxScreenTemplate template;
    private final Set<TemplateListener> listeners = new HashSet<TemplateListener>();

    public DefaultScreenModule(Shell shell, BannerProcessor bannerProcessor) {
        if (shell == null) {
            throw new NullPointerException("Shell");
        }
        if (bannerProcessor == null) {
            throw new NullPointerException("BannerProcessor");
        }
        this.shell = shell;
        this.bannerProcessor = bannerProcessor;
    }

    @Override
    public void show(FxScreenTemplate template) {
        if (this.template != null) {
            for (TemplateListener tl : this.listeners) {
                tl.onRemove(this.template);
            }
            this.template.setVisible(false);
        }
        this.template = template;
        ScreenProcessor.process(template, template.getDefaultBundle());
        ScreenProcessor.process(this.shell, this.shell.getDefaultBundle());
        this.bannerProcessor.process(template);
        for (TemplateListener tl : this.listeners) {
            tl.onAdd(this.template, this.bannerProcessor);
        }
        this.shell.showContent(template);
        this.template.setVisible(true);
    }

    @Override
    public void refresh() {
        if (this.shell != null) {
            ScreenProcessor.process(this.shell, this.shell.getDefaultBundle());
        }
        if (this.template != null) {
            ScreenProcessor.process(this.template, this.template.getDefaultBundle());
        }
    }

    @Override
    public void addTemplateListener(TemplateListener listener) {
        if (listener == null) {
            throw new NullPointerException("TemplateListener");
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeTemplateListener(TemplateListener listener) {
        if (listener == null) {
            throw new NullPointerException("TemplateListener");
        }
        this.listeners.remove(listener);
    }
}

