/*
 * Decompiled with CFR 0.152.
 */
package plfx.shell;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import org.apache.log4j.Logger;
import plfx.Options;
import plfx.shell.ShellControl;

public class BaseShellControl
implements ShellControl {
    private final Pane pane;
    private final Node node;
    private final String id;
    private final BooleanProperty visibleProperty;
    private final Logger log = Options.DEBUG;

    public BaseShellControl(Pane pane, Node node, String id) {
        this.pane = pane;
        this.node = node;
        this.id = id;
        this.visibleProperty = new SimpleBooleanProperty(false);
    }

    @Override
    public void show() {
        this.log.info((Object)("*SHELL CONTROL " + this.id + " show"));
        if (!this.pane.getChildren().contains((Object)this.node)) {
            throw new IllegalStateException("Show: node remove from pane, id: " + this.id);
        }
        this.pane.setVisible(true);
        this.visibleProperty.set(true);
    }

    @Override
    public void hide() {
        this.log.info((Object)("*SHELL CONTROL " + this.id + " hide"));
        if (!this.pane.getChildren().contains((Object)this.node)) {
            throw new IllegalStateException("Hide: node remove from pane, id: " + this.id);
        }
        this.pane.setVisible(false);
        this.pane.getChildren().clear();
        this.visibleProperty.set(false);
    }

    @Override
    public ReadOnlyBooleanProperty visibleProperty() {
        return this.visibleProperty;
    }
}

