/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.utility.search;

import java.lang.reflect.Constructor;
import java.net.URL;
import java.util.Map;
import java.util.Properties;
import plfx.GuiNotifier;
import plfx.element.FxInitException;
import plfx.input.keyboard.letter.Layout;
import plfx.input.keyboard.letter.LayoutLoader;
import plfx.screen.ScreenCreateException;
import plfx.screen.utility.search.DefaultSearchScreen;
import plfx.screen.utility.search.DefaultSearchTemplate;
import plfx.screen.utility.search.SearchScreen;
import plfx.screen.utility.search.SearchTemplate;
import plfx.util.LoadTemplateException;
import plfx.util.Locator;
import plfx.util.ResourceLoader;

public class SearchScreenFactory {
    private SearchScreenFactory() {
    }

    public static SearchScreen createSearchScreen() throws ScreenCreateException {
        try {
            Map<String, Layout> layouts;
            Properties prop = Locator.readQuietly("/gui/skin/{name}//screen/utility/search/descriptor.properties", false);
            SearchTemplate template = null;
            String controller = prop.getProperty("controller", "");
            if (!controller.isEmpty()) {
                try {
                    template = (SearchTemplate)Class.forName(controller).newInstance();
                }
                catch (Throwable throwable) {
                    GuiNotifier.notifyError(throwable);
                    template = new DefaultSearchTemplate();
                }
            } else {
                template = new DefaultSearchTemplate();
            }
            ResourceLoader.load(Locator.getUrl("/gui/skin/{name}//screen/utility/search/template.fxml"), template);
            URL url = Locator.getUrl("/gui/skin/{name}/css/menu.css");
            if (url != null) {
                template.addUserStylesheet(url.toExternalForm());
            }
            template.init();
            try {
                layouts = LayoutLoader.readLayouts("/screen/utility/search/layout.properties", new Properties());
            }
            catch (FxInitException ex) {
                layouts = LayoutLoader.readLayouts("/layout/default.properties", new Properties());
            }
            SearchScreen screen = null;
            String screenName = prop.getProperty("screen", "");
            if (!screenName.isEmpty()) {
                try {
                    Constructor<?> c = Class.forName(screenName).getConstructor(SearchTemplate.class, Map.class);
                    screen = (SearchScreen)c.newInstance(template, layouts);
                }
                catch (Throwable throwable) {
                    GuiNotifier.notifyError(throwable);
                    screen = new DefaultSearchScreen(template, layouts);
                }
            } else {
                screen = new DefaultSearchScreen(template, layouts);
            }
            return screen;
        }
        catch (FxInitException | LoadTemplateException ex) {
            GuiNotifier.notifyError(ex);
            throw new ScreenCreateException("Erron on create search temlate", ex);
        }
    }
}

