/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.utility.search;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.layout.Pane;
import plfx.element.FxInitException;
import plfx.element.SButton;
import plfx.input.keyboard.letter.LetterKeyboard;
import plfx.screen.BaseFxScreenTemplate;
import plfx.screen.menu.StyleExtractor;
import plfx.screen.menu.area.ButtonArea;
import plfx.screen.menu.area.ListButtonArea;
import plfx.screen.menu.button.MenuButton;
import plfx.screen.menu.button.MenuButtonInit;
import plfx.screen.utility.search.SearchTemplate;

class DefaultSearchTemplate
extends BaseFxScreenTemplate
implements SearchTemplate {
    @FXML
    private LetterKeyboard keyboardController;
    @FXML
    private Label requestLabel;
    @FXML
    private Label helpLabel;
    @FXML
    private Label notfoundLabel;
    @FXML
    private Pane buttonPane;
    private SButton backBtn;
    private SButton prevBtn;
    private SButton nextBtn;
    private final List<MenuButton> buttons;
    private final ButtonArea area;
    private final Set<String> styles = new HashSet<String>();

    public DefaultSearchTemplate() {
        super("screen.search", "skin");
        this.buttons = new LinkedList<MenuButton>();
        this.area = new ListButtonArea(this.buttons, "default-mixed", this.styles);
    }

    @Override
    public void init() throws FxInitException {
        super.init();
        this.backBtn = this.searchButton("backButton");
        this.prevBtn = this.searchButton("browsePrevButton");
        this.nextBtn = this.searchButton("browseNextButton");
        this.fill(this.buttons, "service");
    }

    @Override
    public ButtonArea getButtonArea() {
        return this.area;
    }

    @Override
    public Label getRequestLabel() {
        return this.requestLabel;
    }

    @Override
    public SButton getBackButton() {
        return this.backBtn;
    }

    public Pane getButtonPane() {
        return this.buttonPane;
    }

    private void fill(List<MenuButton> list, String prefix) throws FxInitException {
        MenuButton mb;
        for (int i = 0; i < 50 && (mb = this.searchMenuButton(prefix + i, prefix)) != null; ++i) {
            list.add(mb);
        }
    }

    @Override
    public SButton getPrevButton() {
        return this.prevBtn;
    }

    @Override
    public SButton getNextButton() {
        return this.nextBtn;
    }

    @Override
    public LetterKeyboard getLetterKeyboard() {
        return this.keyboardController;
    }

    @Override
    public void update(List<MenuButtonInit> inits, boolean showPrev, boolean showNext) {
        this.getButtonPane().setVisible(false);
        this.helpLabel.setVisible(false);
        this.notfoundLabel.setVisible(false);
        this.getPrevButton().setVisible(false);
        this.getNextButton().setVisible(false);
        if (inits == null) {
            this.helpLabel.setVisible(true);
        } else if (inits.isEmpty()) {
            this.notfoundLabel.setVisible(true);
        } else if (inits.size() <= this.getButtonArea().getCapacity()) {
            this.getPrevButton().setVisible(true);
            this.getNextButton().setVisible(true);
            this.getPrevButton().setDisable(!showPrev);
            this.getNextButton().setDisable(!showNext);
            this.getButtonArea().fill(inits);
            this.getButtonPane().setVisible(true);
        } else {
            throw new IllegalArgumentException("Inits size must be less or equal: " + inits);
        }
    }

    @Override
    public void addUserStylesheet(String url) {
        this.styles.addAll(StyleExtractor.extractStyles(url));
        this.getPane().getStylesheets().add((Object)url);
    }
}

