/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.utility.search;

import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import plfx.element.ButtonListener;
import plfx.input.keyboard.KeyboardModelListener;
import plfx.input.keyboard.letter.Layout;
import plfx.input.keyboard.letter.LetterKeyboard;
import plfx.model.textfield.FieldListener;
import plfx.model.textfield.TextFieldModel;
import plfx.screen.FxScreenTemplate;
import plfx.screen.menu.button.MenuButtonInit;
import plfx.screen.utility.search.SearchListener;
import plfx.screen.utility.search.SearchScreen;
import plfx.screen.utility.search.SearchTemplate;
import ru.softlogic.input.model.field.text.Filter;
import ru.softlogic.input.model.field.text.Keyboard;
import ru.softlogic.input.model.field.text.KeyboardCase;
import ru.softlogic.input.model.field.text.KeyboardType;
import ru.softlogic.input.model.field.text.VoidFilter;

class DefaultSearchScreen
implements SearchScreen {
    private SearchTemplate template;
    private SearchListener listener;
    private LetterKeyboard keyboard;
    private TextFieldModel model;
    private List<String> kbds;
    private Locale currentLocale;

    public DefaultSearchScreen(SearchTemplate template, Map<String, Layout> layouts) {
        if (template == null) {
            throw new NullPointerException();
        }
        this.template = template;
        template.getBackButton().setListener(new ExitListener());
        template.getPrevButton().setListener(new PrevListener());
        template.getNextButton().setListener(new NextListener());
        this.keyboard = template.getLetterKeyboard();
        this.keyboard.setLayouts(layouts);
        this.kbds = new LinkedList<String>();
        for (Layout l : layouts.values()) {
            if ("symb".equals(l.getCode())) continue;
            this.kbds.add(l.getCode());
        }
        this.model = new TextFieldModel(20, "", "", false, (Filter)new VoidFilter());
        this.model.addListener(new LocalFieldListener());
        this.keyboard.setKeyboardListener(new KeyboardModelListener(this.model));
    }

    @Override
    public void init() {
        this.model.clear();
        this.kbds.sort((l1, l2) -> {
            if (l1.equalsIgnoreCase(this.currentLocale.getLanguage())) {
                return -1;
            }
            if (l2.equalsIgnoreCase(this.currentLocale.getLanguage())) {
                return 1;
            }
            return 0;
        });
        this.keyboard.init(new Keyboard(KeyboardType.Any, this.kbds, KeyboardCase.Upper, true, null));
    }

    @Override
    public void setListener(SearchListener listener) {
        if (listener == null) {
            throw new NullPointerException("Listener is not set");
        }
        this.listener = listener;
    }

    @Override
    public FxScreenTemplate getTemplate() {
        return this.template;
    }

    @Override
    public int getButtonCount() {
        return this.template.getButtonArea().getCapacity();
    }

    @Override
    public void update(List<MenuButtonInit> inits, boolean showPrev, boolean showNext) {
        this.template.update(inits, showPrev, showNext);
    }

    @Override
    public void setCurrentLocale(Locale locale) {
        this.currentLocale = locale;
    }

    private class NextListener
    implements ButtonListener {
        private NextListener() {
        }

        @Override
        public void onAction() {
            if (DefaultSearchScreen.this.listener != null) {
                DefaultSearchScreen.this.listener.onBrowseNext();
            }
        }
    }

    private class PrevListener
    implements ButtonListener {
        private PrevListener() {
        }

        @Override
        public void onAction() {
            if (DefaultSearchScreen.this.listener != null) {
                DefaultSearchScreen.this.listener.onBrowsePrev();
            }
        }
    }

    private class ExitListener
    implements ButtonListener {
        private ExitListener() {
        }

        @Override
        public void onAction() {
            if (DefaultSearchScreen.this.listener != null) {
                DefaultSearchScreen.this.listener.onExit();
            }
        }
    }

    private class LocalFieldListener
    implements FieldListener {
        private LocalFieldListener() {
        }

        @Override
        public void onChange(String value) {
            DefaultSearchScreen.this.template.getRequestLabel().setText(value);
            if (DefaultSearchScreen.this.listener != null) {
                DefaultSearchScreen.this.listener.onRequest(value);
            }
        }

        @Override
        public void onEnter(String value) {
            if (DefaultSearchScreen.this.listener != null) {
                DefaultSearchScreen.this.listener.onRequest(value);
            }
        }
    }
}

