/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.utility.lock;

import java.lang.reflect.Constructor;
import java.util.Properties;
import plfx.GuiNotifier;
import plfx.element.FxInitException;
import plfx.screen.ScreenCreateException;
import plfx.screen.utility.lock.DefaultLockScreen;
import plfx.screen.utility.lock.DefaultLockTemplate;
import plfx.screen.utility.lock.LockScreen;
import plfx.screen.utility.lock.LockTemplate;
import plfx.util.LoadTemplateException;
import plfx.util.Locator;
import plfx.util.ResourceLoader;

public class LockScreenFactory {
    private LockScreenFactory() {
    }

    public static LockScreen createLockScreen() throws ScreenCreateException {
        try {
            Properties prop = Locator.readQuietly("/gui/skin/{name}//screen/utility/lock/descriptor.properties", false);
            LockTemplate template = new DefaultLockTemplate();
            String controller = prop.getProperty("controller", "");
            if (!controller.isEmpty()) {
                try {
                    template = (LockTemplate)Class.forName(controller).newInstance();
                }
                catch (Throwable throwable) {
                    GuiNotifier.notifyError(throwable);
                }
            }
            ResourceLoader.load(Locator.getUrl("/gui/skin/{name}//screen/utility/lock/template.fxml"), template);
            template.init();
            LockScreen screen = new DefaultLockScreen(template);
            String screenName = prop.getProperty("screen", "");
            if (!screenName.isEmpty()) {
                try {
                    Constructor<?> c = Class.forName(screenName).getConstructor(LockTemplate.class);
                    screen = (LockScreen)c.newInstance(template);
                }
                catch (Throwable throwable) {
                    GuiNotifier.notifyError(throwable);
                }
            }
            return screen;
        }
        catch (FxInitException | LoadTemplateException ex) {
            GuiNotifier.notifyError(ex);
            throw new ScreenCreateException("Erron on create lock screen", ex);
        }
    }
}

