/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.utility.lock;

import plfx.input.keyboard.KeyboardListener;
import plfx.input.keyboard.digital.DigitalKeyboard;
import plfx.screen.FxScreenTemplate;
import plfx.screen.ScreenListener;
import plfx.screen.utility.lock.LockScreen;
import plfx.screen.utility.lock.LockTemplate;

public class DefaultLockScreen
implements LockScreen {
    private final LockTemplate template;
    private final DigitalKeyboard keyboard;
    private ScreenListener listener;

    public DefaultLockScreen(LockTemplate template) {
        if (template == null) {
            throw new NullPointerException("LockTemplate is not set");
        }
        this.template = template;
        this.keyboard = template.getDigitalKeyboard();
        template.getNextLangButton().setListener(() -> {
            if (this.listener != null) {
                this.listener.onNextLang();
            }
        });
    }

    @Override
    public void setKeyboardListener(KeyboardListener listener) {
        if (this.keyboard != null) {
            this.keyboard.setKeyboardListener(listener);
        }
    }

    @Override
    public FxScreenTemplate getTemplate() {
        return this.template;
    }

    @Override
    public void setScreenListener(ScreenListener listener) {
        this.listener = listener;
    }
}

