/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.utility.launch;

import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.layout.Pane;
import plfx.element.FxInitException;
import plfx.screen.BaseFxScreenTemplate;
import plfx.screen.utility.launch.ErrorScreenListener;

class DefaultLaunchErrorTemplate
extends BaseFxScreenTemplate {
    private ErrorScreenListener listener;
    @FXML
    private PasswordField pfPassword;
    @FXML
    private Label errorMessage;
    @FXML
    private Pane kb;
    @FXML
    private Pane buttonPane;
    private String pass;

    public DefaultLaunchErrorTemplate(String pass) {
        super("screen.launch", "ext");
        this.pass = pass;
    }

    @Override
    public void init() throws FxInitException {
        super.init();
        this.buttonPane.visibleProperty().bind((ObservableValue)this.kb.visibleProperty().not());
        this.kb.setVisible(true);
    }

    public void setListener(ErrorScreenListener listener) {
        this.listener = listener;
    }

    @FXML
    public void onConfigure() {
        if (this.listener != null) {
            this.listener.onConfigure();
        }
    }

    @FXML
    public void onTurnOff() {
        if (this.listener != null) {
            this.listener.onTurnOff();
        }
    }

    @FXML
    public void onReboot() {
        if (this.listener != null) {
            this.listener.onReboot();
        }
    }

    @FXML
    public void onVpn() {
        if (this.listener != null) {
            this.listener.onStartVpn();
        }
    }

    @FXML
    public void passwordValidate(ActionEvent ev) {
        if (this.listener != null) {
            String pwd = this.pfPassword.getText();
            if (!pwd.equals(this.pass)) {
                this.errorMessage.setVisible(true);
                this.kb.setVisible(true);
            } else {
                this.errorMessage.setVisible(false);
                this.kb.setVisible(false);
            }
        }
    }

    @FXML
    public void passwordCharInput(ActionEvent ev) {
        Button btn = (Button)ev.getSource();
        this.pfPassword.setText(this.pfPassword.getText() + btn.getText());
        this.errorMessage.setVisible(false);
    }

    @FXML
    public void clear(ActionEvent ev) {
        this.pfPassword.setText("");
        this.errorMessage.setVisible(false);
    }

    @FXML
    public void backspace(ActionEvent ev) {
        if (this.pfPassword.getLength() > 0) {
            String pwd = this.pfPassword.getText(0, this.pfPassword.getLength() - 1);
            this.errorMessage.setVisible(false);
            this.pfPassword.setText(pwd);
        }
    }
}

