/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.utility.launch;

import plfx.element.FxInitException;
import plfx.screen.ScreenCreateException;
import plfx.screen.utility.launch.DefaultLaunchErrorScreen;
import plfx.screen.utility.launch.DefaultLaunchErrorTemplate;
import plfx.screen.utility.launch.LaunchErrorScreen;
import plfx.skin.Resolution;
import plfx.util.LoadTemplateException;
import plfx.util.Locator;
import plfx.util.ResourceLoader;

public class DefaultErrorFactory {
    private DefaultErrorFactory() {
    }

    public static LaunchErrorScreen createLaunchErrorScreen(Resolution resolution, String pass) throws ScreenCreateException {
        try {
            DefaultLaunchErrorTemplate template = new DefaultLaunchErrorTemplate(pass);
            String css = Locator.getPath("/gui/system/error//" + resolution.getWidth() + "x" + resolution.getHeight() + ".css");
            if (css == null) {
                css = Locator.getPath("/gui/system/error//default.css");
            }
            ResourceLoader.load(Locator.getUrl("/gui/system/error//template.fxml"), template);
            template.init();
            if (css != null) {
                template.getPane().getStylesheets().add((Object)css);
            }
            return new DefaultLaunchErrorScreen(template);
        }
        catch (FxInitException | LoadTemplateException ex) {
            throw new ScreenCreateException("Error on create error screen template", ex);
        }
    }
}

