/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.utility.launch;

import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.PasswordField;
import javafx.scene.layout.Pane;
import org.apache.commons.lang.exception.ExceptionUtils;
import plfx.screen.utility.launch.ErrorScreenListener;

public class CrashScreenTemplate {
    @FXML
    private Pane kb;
    @FXML
    private Pane rootPane;
    @FXML
    private Pane buttonPane;
    @FXML
    private Label messageLabel;
    @FXML
    private Label titleLabel;
    @FXML
    private Label traceLabel;
    @FXML
    private Button btnConfigure;
    @FXML
    private Button btnTurnOff;
    @FXML
    private Button btnReboot;
    @FXML
    private Button btnVpn;
    @FXML
    PasswordField pfPassword;
    @FXML
    Label errorMessage;
    private final Throwable throwable;
    private final ErrorScreenListener listener;
    String pass;

    public Pane getPane() {
        return this.rootPane;
    }

    public CrashScreenTemplate(Throwable th, ErrorScreenListener listener, String pass) {
        this.throwable = th;
        this.listener = listener;
        this.pass = pass;
    }

    public void init() {
        this.buttonPane.setDisable(true);
        this.buttonPane.setVisible(false);
        this.titleLabel.setText("Unable to run the terminal");
        this.messageLabel.setText(this.throwable.getMessage());
        this.traceLabel.setText("Stack:" + ExceptionUtils.getStackTrace((Throwable)this.throwable));
        this.btnConfigure.setText("Start configurator");
        this.btnTurnOff.setText("Switch off");
        this.btnReboot.setText("Reload");
        this.btnVpn.setText("Start VPN");
    }

    @FXML
    public void onConfigure() {
        if (this.listener != null) {
            this.listener.onConfigure();
        }
    }

    @FXML
    public void onTurnOff() {
        if (this.listener != null) {
            this.listener.onTurnOff();
        }
    }

    @FXML
    public void onReboot() {
        if (this.listener != null) {
            this.listener.onReboot();
        }
    }

    @FXML
    public void onVpn() {
        if (this.listener != null) {
            this.listener.onStartVpn();
        }
    }

    @FXML
    public void passwordValidate(ActionEvent ev) {
        if (this.listener != null) {
            String pwd = this.pfPassword.getText();
            if (!pwd.equals(this.pass)) {
                this.errorMessage.setVisible(true);
                this.kb.setVisible(true);
            } else {
                this.errorMessage.setVisible(false);
                this.kb.setVisible(false);
                this.buttonPane.setDisable(false);
                this.buttonPane.setVisible(true);
            }
        }
    }

    @FXML
    public void passwordCharInput(ActionEvent ev) {
        Button btn = (Button)ev.getSource();
        this.pfPassword.setText(this.pfPassword.getText() + btn.getText());
        this.errorMessage.setVisible(false);
    }

    @FXML
    public void clear(ActionEvent ev) {
        this.pfPassword.setText("");
        this.errorMessage.setVisible(false);
    }

    @FXML
    public void backspace(ActionEvent ev) {
        if (this.pfPassword.getLength() > 0) {
            String pwd = this.pfPassword.getText(0, this.pfPassword.getLength() - 1);
            this.errorMessage.setVisible(false);
            this.pfPassword.setText(pwd);
        }
    }
}

