/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.utility.console.encash;

import java.util.LinkedList;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import plfx.screen.FxScreenTemplate;
import plfx.screen.Screen;
import plfx.screen.utility.console.TableModel;
import plfx.screen.utility.console.encash.EncashListTemplate;

public class EncashListScreen
implements Screen {
    private final EncashListTemplate template;

    public EncashListScreen(EncashListTemplate template) {
        this.template = template;
    }

    public void init(TableModel model, boolean addEnable) {
        ObservableList list = FXCollections.observableArrayList(model != null ? model.getRows() : new LinkedList());
        this.template.getTable().setItems(list);
        this.template.getTable().getSelectionModel().select(0);
        this.template.getRefillButton().setDisable(list.isEmpty());
        this.template.getAddItemButton().setVisible(addEnable);
    }

    public void setListener(Listener listener) {
        this.template.setListener(listener);
    }

    @Override
    public FxScreenTemplate getTemplate() {
        return this.template;
    }

    public static interface Listener {
        public void onCancel();

        public void onAddDenomination();

        public void onRefill();
    }
}

