/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.utility.console.encash;

import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Label;
import plfx.element.FxInitException;
import plfx.input.keyboard.KeyboardModelListener;
import plfx.input.keyboard.digital.DefaultDigitalKeyboard;
import plfx.model.textfield.FieldListener;
import plfx.model.textfield.NumericFieldModel;
import plfx.screen.BaseFxScreenTemplate;
import plfx.screen.utility.console.SelectorModel;
import plfx.screen.utility.console.encash.EncashAddScreen;
import ru.softlogic.input.model.field.text.DigitalFilter;
import ru.softlogic.input.model.field.text.Filter;
import ru.softlogic.input.model.field.text.NumericRangeValidator;

public class EncashAddTemplate
extends BaseFxScreenTemplate {
    @FXML
    private Button addButton;
    @FXML
    private Label count;
    @FXML
    private ComboBox<SelectorModel.Item> denominations;
    @FXML
    private DefaultDigitalKeyboard keyboardController;
    private final NumericFieldModel model;
    private final BooleanProperty valid = new SimpleBooleanProperty();
    private EncashAddScreen.Listener listener;
    private NumericRangeValidator validator;

    public EncashAddTemplate() {
        super("screen.encashadd", "ext");
        this.model = new NumericFieldModel(4, 0, false, (Filter)new DigitalFilter());
        this.model.addListener(new LocalFieldModel());
    }

    @Override
    public void init() throws FxInitException {
        super.init();
        this.addButton.disableProperty().bind((ObservableValue)this.denominations.getSelectionModel().selectedItemProperty().isNull().or((ObservableBooleanValue)this.valid.not()));
        if (this.keyboardController != null) {
            this.keyboardController.setKeyboardListener(new KeyboardModelListener(this.model));
        }
    }

    public void setListener(EncashAddScreen.Listener listener) {
        this.listener = listener;
    }

    @FXML
    private void onCancel() {
        if (this.listener != null) {
            this.listener.onCancel();
        }
    }

    @FXML
    private void onAdd() {
        if (this.listener != null) {
            this.listener.onAddItem(this.denominations.getSelectionModel().getSelectedIndex(), Integer.parseInt(this.model.getClearValue()));
        }
    }

    public ComboBox<SelectorModel.Item> getDenominations() {
        return this.denominations;
    }

    public void setValidator(NumericRangeValidator validator) {
        this.validator = validator;
    }

    public NumericFieldModel getModel() {
        return this.model;
    }

    private class LocalFieldModel
    implements FieldListener {
        private LocalFieldModel() {
        }

        @Override
        public void onChange(String value) {
            EncashAddTemplate.this.count.setText(value);
            EncashAddTemplate.this.valid.set(EncashAddTemplate.this.validator.validate(EncashAddTemplate.this.model.getClearValue()));
        }

        @Override
        public void onEnter(String value) {
        }
    }
}

