/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.utility.console;

import java.util.List;

public class SelectorModel {
    private final List<Item> items;
    private final int selectedItem;
    private final boolean disabled;

    public SelectorModel(List<Item> items) {
        this(items, 0, false);
    }

    public SelectorModel(List<Item> items, int selectedItem, boolean disabled) {
        this.items = items;
        this.selectedItem = selectedItem;
        this.disabled = disabled;
    }

    public List<Item> getItems() {
        return this.items;
    }

    public int getSelectedItem() {
        return this.selectedItem;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public static class Item {
        private final String title;
        private final Runnable itemAction;

        public Item(String title) {
            this(title, null);
        }

        public Item(String title, Runnable itemAction) {
            this.title = title;
            this.itemAction = itemAction;
        }

        public String getTitle() {
            return this.title;
        }

        public String toString() {
            return this.title;
        }

        public void makeAction() {
            if (this.itemAction != null) {
                this.itemAction.run();
            }
        }
    }
}

