/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.utility.console;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Tab;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.util.Callback;
import plfx.Options;
import plfx.screen.FxScreenTemplate;
import plfx.screen.utility.console.CashModule;
import plfx.screen.utility.console.CollectionModule;
import plfx.screen.utility.console.ConsoleModule;
import plfx.screen.utility.console.ConsoleScreen;
import plfx.screen.utility.console.CvdModule;
import plfx.screen.utility.console.DefaultConsoleTemplate;
import plfx.screen.utility.console.DeviceStateRecord;
import plfx.screen.utility.console.FinancialQueueItem;
import plfx.screen.utility.console.InfoModule;
import plfx.screen.utility.console.KkmModule;
import plfx.screen.utility.console.LogArea;
import plfx.screen.utility.console.LogModule;
import plfx.screen.utility.console.MainModule;
import plfx.screen.utility.console.ModemModule;
import plfx.screen.utility.console.QueueModule;
import plfx.screen.utility.console.SelectorModel;
import plfx.screen.utility.console.SmsRecord;
import plfx.screen.utility.console.TableModel;
import plfx.screen.utility.console.TextLogArea;

class DefaultConsoleScreen
implements ConsoleScreen {
    private final DefaultConsoleTemplate template;
    private final LogArea logArea;
    private final List<Tab> originalTabs;
    private final MainModule mainModule = new LocalMainModule();
    private final KkmModule kkmModule = new LocalKkmModule();
    private final CashModule cashModule = new LocalCashModule();
    private final CvdModule cvdModule = new LocalCvdModule();
    private final ModemModule modemModule = new LocalModemModule();
    private final CollectionModule collectionModule = new LocalCollectionModule();
    private final LogModule logModule = new LocalLogModule();
    private final InfoModule infoModule = new LocalInfoModule();
    private final QueueModule queueModule = new LocalQueueModule();

    public DefaultConsoleScreen(DefaultConsoleTemplate template) {
        this.template = Objects.requireNonNull(template, "DefaultConsoleTemplate");
        this.logArea = new TextLogArea(template.getLogTextArea());
        this.originalTabs = new LinkedList<Tab>();
        this.originalTabs.addAll((Collection<Tab>)template.getTabPane().getTabs());
        template.getDevStateTable().setRowFactory((Callback)new DeviceRowRender());
    }

    @Override
    public void init() {
        this.template.getTabPane().getSelectionModel().select(0);
        this.template.getCollectionTable().getItems().clear();
    }

    @Override
    public FxScreenTemplate getTemplate() {
        return this.template;
    }

    @Override
    public MainModule getMainModule() {
        return this.mainModule;
    }

    @Override
    public CashModule getCashStoreModule() {
        return this.cashModule;
    }

    @Override
    public LogModule getLogModule() {
        return this.logModule;
    }

    @Override
    public CollectionModule getCollectionModule() {
        return this.collectionModule;
    }

    @Override
    public CvdModule getCvdModule() {
        return this.cvdModule;
    }

    @Override
    public ModemModule getModemModule() {
        return this.modemModule;
    }

    @Override
    public InfoModule getInfoModule() {
        return this.infoModule;
    }

    @Override
    public KkmModule getKkmModule() {
        return this.kkmModule;
    }

    @Override
    public QueueModule getQueueModule() {
        return this.queueModule;
    }

    private void setState(Tab tab, ConsoleModule.State state) {
        if (tab != null && state != null) {
            if (state == ConsoleModule.State.Hide) {
                this.template.getTabPane().getTabs().remove((Object)tab);
            } else {
                tab.setDisable(!ConsoleModule.State.Visible.equals((Object)state));
            }
        } else {
            Options.GUI.error((Object)"Tabs is null");
        }
    }

    private void setState(Button tab, ConsoleModule.State state) {
        if (tab != null && state != null) {
            tab.setDisable(!ConsoleModule.State.Visible.equals((Object)state));
        } else {
            Options.GUI.error((Object)"Button is null");
        }
    }

    private class LocalCashModule
    implements CashModule {
        private LocalCashModule() {
        }

        @Override
        public void setTabState(ConsoleModule.State state) {
            DefaultConsoleScreen.this.setState(DefaultConsoleScreen.this.template.getStoreTab(), state);
        }

        @Override
        public void setButtonState(int buttonId, ConsoleModule.State state) {
            if (buttonId == 3) {
                DefaultConsoleScreen.this.setState(DefaultConsoleScreen.this.template.getBoxRefillButton(), state);
            } else if (buttonId == 4) {
                DefaultConsoleScreen.this.setState(DefaultConsoleScreen.this.template.getBoxCollectionButton(), state);
            } else if (buttonId == 7) {
                DefaultConsoleScreen.this.setState(DefaultConsoleScreen.this.template.getAllBoxCollectionButton(), state);
            } else if (buttonId == 5) {
                DefaultConsoleScreen.this.setState(DefaultConsoleScreen.this.template.getBoxClearViaMainButton(), state);
            } else if (buttonId == 6) {
                DefaultConsoleScreen.this.setState(DefaultConsoleScreen.this.template.getBoxClearViaSecondButton(), state);
            }
        }

        @Override
        public void setStores(SelectorModel model) {
            ComboBox<SelectorModel.Item> selector = DefaultConsoleScreen.this.template.getCbStore();
            selector.getItems().clear();
            if (model != null) {
                selector.getItems().addAll(model.getItems());
                selector.getSelectionModel().select(null);
                selector.getSelectionModel().select(model.getSelectedItem());
                selector.setDisable(model.isDisabled());
            }
        }

        @Override
        public void setBoxes(SelectorModel model) {
            ComboBox<SelectorModel.Item> selector = DefaultConsoleScreen.this.template.getCbBoxes();
            selector.getItems().clear();
            if (model != null) {
                selector.getItems().addAll(model.getItems());
                selector.getSelectionModel().select(null);
                selector.getSelectionModel().select(model.getSelectedItem());
                selector.setDisable(model.isDisabled());
            }
        }

        @Override
        public void setStoreContent(TableModel model) {
            ObservableList list = FXCollections.observableArrayList(model != null ? model.getRows() : new LinkedList());
            DefaultConsoleScreen.this.template.getTotalDenoninationsTable().setItems(list);
            DefaultConsoleScreen.this.template.getTotalDenoninationsTable().getSelectionModel().select(0);
        }

        @Override
        public void setBoxContent(TableModel model, String lastCollect, String lastRefill) {
            ObservableList list = FXCollections.observableArrayList(model != null ? model.getRows() : new LinkedList());
            DefaultConsoleScreen.this.template.getBoxTable().setItems(list);
            DefaultConsoleScreen.this.template.getBoxTable().getSelectionModel().select(0);
            DefaultConsoleScreen.this.template.getBoxEmptyDate().setText(lastCollect);
            DefaultConsoleScreen.this.template.getBoxRefillDate().setText(lastRefill);
        }

        @Override
        public ProgressBar getProgressBar() {
            return DefaultConsoleScreen.this.template.getProgressBar();
        }

        @Override
        public void setListener(CashModule.Listener listener) {
            DefaultConsoleScreen.this.template.setListener(listener);
        }
    }

    private class LocalMainModule
    implements MainModule {
        private LocalMainModule() {
        }

        @Override
        public void setListener(MainModule.Listener listener) {
            DefaultConsoleScreen.this.template.setListener(listener);
        }

        @Override
        public void setTabState(ConsoleModule.State state) {
            DefaultConsoleScreen.this.setState(DefaultConsoleScreen.this.template.getMainTab(), state);
        }

        @Override
        public ProgressBar getProgressBar() {
            return DefaultConsoleScreen.this.template.getProgressBar();
        }

        @Override
        public void setButtonState(int buttonId, ConsoleModule.State state) {
            if (buttonId == 12) {
                DefaultConsoleScreen.this.setState(DefaultConsoleScreen.this.template.getTestPrinter(), state);
            } else if (buttonId == 11) {
                DefaultConsoleScreen.this.setState(DefaultConsoleScreen.this.template.getTestConnect(), state);
            } else if (buttonId == 2) {
                DefaultConsoleScreen.this.setState(DefaultConsoleScreen.this.template.getCheckBalance(), state);
            } else if (buttonId == 1) {
                DefaultConsoleScreen.this.setState(DefaultConsoleScreen.this.template.getCalibrate(), state);
            } else if (buttonId == 13) {
                DefaultConsoleScreen.this.setState(DefaultConsoleScreen.this.template.getOpenPanel(), state);
            } else if (buttonId == 6) {
                DefaultConsoleScreen.this.setState(DefaultConsoleScreen.this.template.getMinimize(), state);
            } else if (buttonId == 9) {
                DefaultConsoleScreen.this.setState(DefaultConsoleScreen.this.template.getRebootSoftware(), state);
            } else if (buttonId == 3) {
                DefaultConsoleScreen.this.setState(DefaultConsoleScreen.this.template.getTurnoffSoftware(), state);
            } else if (buttonId == 8) {
                DefaultConsoleScreen.this.setState(DefaultConsoleScreen.this.template.getRebootTerminal(), state);
            } else if (buttonId == 7) {
                DefaultConsoleScreen.this.setState(DefaultConsoleScreen.this.template.getTurnoffTerminal(), state);
            } else if (buttonId == 4) {
                DefaultConsoleScreen.this.setState(DefaultConsoleScreen.this.template.getUpdateNetwork(), state);
            } else if (buttonId == 5) {
                DefaultConsoleScreen.this.setState(DefaultConsoleScreen.this.template.getUpdateMedia(), state);
            } else if (buttonId == 10) {
                DefaultConsoleScreen.this.setState(DefaultConsoleScreen.this.template.getConfigure(), state);
                DefaultConsoleScreen.this.setState(DefaultConsoleScreen.this.template.getRunConf(), state);
            } else if (buttonId == 14) {
                DefaultConsoleScreen.this.setState(DefaultConsoleScreen.this.template.getUpdateJava(), state);
            } else if (buttonId == 16) {
                DefaultConsoleScreen.this.setState(DefaultConsoleScreen.this.template.getCollectCash(), state);
            } else if (buttonId == 17) {
                DefaultConsoleScreen.this.setState(DefaultConsoleScreen.this.template.getCollectCoin(), state);
            }
        }
    }

    private class LocalKkmModule
    implements KkmModule {
        private LocalKkmModule() {
        }

        @Override
        public void setListener(KkmModule.Listener listener) {
            DefaultConsoleScreen.this.template.setListener(listener);
        }

        @Override
        public void setTabState(ConsoleModule.State state) {
            DefaultConsoleScreen.this.setState(DefaultConsoleScreen.this.template.getKkmTab(), state);
        }

        @Override
        public void setButtonState(int buttonId, ConsoleModule.State state) {
        }

        @Override
        public ProgressBar getProgressBar() {
            return DefaultConsoleScreen.this.template.getProgressBar();
        }
    }

    private class LocalModemModule
    implements ModemModule {
        private LocalModemModule() {
        }

        @Override
        public TextField getModemRequest() {
            return DefaultConsoleScreen.this.template.getModemRequest();
        }

        @Override
        public TextField getModemText() {
            return DefaultConsoleScreen.this.template.getModemText();
        }

        @Override
        public void setSmsList(List<SmsRecord> items) {
            ObservableList list = FXCollections.observableArrayList(items);
            DefaultConsoleScreen.this.template.getModemSmsTable().setItems(list);
        }

        @Override
        public void setListener(ModemModule.Listener listener) {
            DefaultConsoleScreen.this.template.setListener(listener);
        }

        @Override
        public void setTabState(ConsoleModule.State state) {
            DefaultConsoleScreen.this.setState(DefaultConsoleScreen.this.template.getModemTab(), state);
        }

        @Override
        public void setButtonState(int buttonId, ConsoleModule.State state) {
        }

        @Override
        public ProgressBar getProgressBar() {
            return DefaultConsoleScreen.this.template.getProgressBar();
        }
    }

    private class LocalCvdModule
    implements CvdModule {
        private LocalCvdModule() {
        }

        @Override
        public void setCvdState(String state) {
            DefaultConsoleScreen.this.template.getCvdState().setText(state);
        }

        @Override
        public void setCvdCount(String count) {
            DefaultConsoleScreen.this.template.getCvdCount().setText(count);
        }

        @Override
        public void setRejectCvdCount(String count) {
            DefaultConsoleScreen.this.template.getCvdRejectCount().setText(count);
        }

        @Override
        public void setTabState(ConsoleModule.State state) {
            DefaultConsoleScreen.this.setState(DefaultConsoleScreen.this.template.getCvdTab(), state);
        }

        @Override
        public void setButtonState(int buttonId, ConsoleModule.State state) {
        }

        @Override
        public ProgressBar getProgressBar() {
            return DefaultConsoleScreen.this.template.getProgressBar();
        }

        @Override
        public void setListener(CvdModule.Listener listener) {
            DefaultConsoleScreen.this.template.setListener(listener);
        }
    }

    private class LocalCollectionModule
    implements CollectionModule {
        private LocalCollectionModule() {
        }

        @Override
        public void setCollections(TableModel model) {
            ObservableList list = FXCollections.observableArrayList(model != null ? model.getRows() : new LinkedList());
            DefaultConsoleScreen.this.template.getCollectionTable().setItems(list);
            DefaultConsoleScreen.this.template.getCollectionTable().getSelectionModel().select(0);
        }

        @Override
        public void setTabState(ConsoleModule.State state) {
            DefaultConsoleScreen.this.setState(DefaultConsoleScreen.this.template.getCcopyTab(), state);
        }

        @Override
        public void setButtonState(int buttonId, ConsoleModule.State state) {
        }

        @Override
        public void setListener(CollectionModule.Listener listener) {
            DefaultConsoleScreen.this.template.setListener(listener);
        }

        @Override
        public ProgressBar getProgressBar() {
            return DefaultConsoleScreen.this.template.getProgressBar();
        }
    }

    private class LocalLogModule
    implements LogModule {
        private LocalLogModule() {
        }

        @Override
        public LogArea getLogArea() {
            return DefaultConsoleScreen.this.logArea;
        }

        @Override
        public void setListener(LogModule.Listener listener) {
            DefaultConsoleScreen.this.template.setListener(listener);
        }

        @Override
        public void setTabState(ConsoleModule.State state) {
            DefaultConsoleScreen.this.setState(DefaultConsoleScreen.this.template.getLogTab(), state);
        }

        @Override
        public void setButtonState(int buttonId, ConsoleModule.State state) {
        }

        @Override
        public ProgressBar getProgressBar() {
            return DefaultConsoleScreen.this.template.getProgressBar();
        }
    }

    private class LocalInfoModule
    implements InfoModule {
        private LocalInfoModule() {
        }

        @Override
        public void setDeviceInfo(List<DeviceStateRecord> items) {
            ObservableList list = FXCollections.observableArrayList(items);
            DefaultConsoleScreen.this.template.getDevStateTable().setItems(list);
        }

        @Override
        public void setTabState(ConsoleModule.State state) {
            DefaultConsoleScreen.this.setState(DefaultConsoleScreen.this.template.getStateTab(), state);
        }

        @Override
        public void setButtonState(int buttonId, ConsoleModule.State state) {
        }

        @Override
        public ProgressBar getProgressBar() {
            return DefaultConsoleScreen.this.template.getProgressBar();
        }
    }

    private class LocalQueueModule
    implements QueueModule {
        private LocalQueueModule() {
        }

        @Override
        public void setFinancialQueueItems(List<FinancialQueueItem> items) {
            ObservableList list = FXCollections.observableArrayList(items);
            DefaultConsoleScreen.this.template.getQueueSize().setText(String.valueOf(items.size()));
            DefaultConsoleScreen.this.template.getQueueTable().setItems(list);
        }

        @Override
        public void setTabState(ConsoleModule.State state) {
            DefaultConsoleScreen.this.setState(DefaultConsoleScreen.this.template.getQueueTab(), state);
        }

        @Override
        public void setButtonState(int buttonId, ConsoleModule.State state) {
        }

        @Override
        public ProgressBar getProgressBar() {
            return DefaultConsoleScreen.this.template.getProgressBar();
        }
    }

    private static final class DeviceRowRender
    implements Callback<TableView<DeviceStateRecord>, TableRow<DeviceStateRecord>> {
        private DeviceRowRender() {
        }

        public TableRow<DeviceStateRecord> call(TableView<DeviceStateRecord> param) {
            TableRow<DeviceStateRecord> row = new TableRow<DeviceStateRecord>(){

                protected void updateItem(DeviceStateRecord record, boolean empty) {
                    super.updateItem((Object)record, empty);
                    if (record != null) {
                        String warning = record.getWarning();
                        if (record.getErrorCode() != 0) {
                            this.getStyleClass().remove((Object)"device-state-warning");
                            this.getStyleClass().add((Object)"device-state-error");
                        } else if (warning != null && !record.getWarning().isEmpty()) {
                            this.getStyleClass().remove((Object)"device-state-error");
                            this.getStyleClass().add((Object)"device-state-warning");
                        } else {
                            this.getStyleClass().remove((Object)"device-state-error");
                            this.getStyleClass().remove((Object)"device-state-warning");
                        }
                    }
                }
            };
            return row;
        }
    }
}

