/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.utility.console;

import java.util.List;
import plfx.screen.utility.console.CashCountRecord;

public class CashBoxInfo {
    public static final int FEATURE_BASE = 0;
    public static final int FEATURE_CAN_EMPTY = 1;
    public static final int FEATURE_CAN_REFILL = 2;
    public static final int FEATURE_SUPPORT_MULTI_DENOMINATION = 4;
    public static final int FEATURE_SUPPORT_MULTI_CURRENCY = 8;
    public static final int FEATURE_CAN_EDIT_CAPACITY = 16;
    public static final int FEATURE_CAN_REFILL_NOT_EMPTY = 32;
    private final List<CashCountRecord> records;
    private final int capacity;
    private final int features;
    private final boolean clearMainChannel;
    private final boolean clearSecondChannel;

    public CashBoxInfo(List<CashCountRecord> records, int capacity, int features, boolean clearMainChannel, boolean clearSecondChannel) {
        this.records = records;
        this.capacity = capacity;
        this.features = features;
        this.clearMainChannel = clearMainChannel;
        this.clearSecondChannel = clearSecondChannel;
    }

    public List<CashCountRecord> getRecords() {
        return this.records;
    }

    public int getCapacity() {
        return this.capacity;
    }

    public boolean isCanEmpty() {
        return this.isFeatureSupport(1);
    }

    public boolean isCanRefill() {
        return this.isFeatureSupport(2);
    }

    public boolean isCanEditCapacity() {
        return this.isFeatureSupport(16);
    }

    public boolean isCanRefillNotEmpty() {
        return this.isFeatureSupport(32);
    }

    public boolean isSupportMultiCurrency() {
        return this.isFeatureSupport(8);
    }

    public boolean isSupportMultiDenomination() {
        return this.isFeatureSupport(4);
    }

    public boolean isClearMainChannel() {
        return this.clearMainChannel;
    }

    public boolean isClearSecondChannel() {
        return this.clearSecondChannel;
    }

    private boolean isFeatureSupport(int feature) {
        return (feature & this.features) != 0;
    }

    public String toString() {
        return "CashBoxInfo{records=" + this.records + ", capacity=" + this.capacity + ", features=" + this.features + ", clearMainChannel=" + this.clearMainChannel + ", clearSecondChannel=" + this.clearSecondChannel + '}';
    }
}

