/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.utility.calib;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import plfx.screen.FxScreenTemplate;
import plfx.screen.utility.calib.CalibListener;
import plfx.screen.utility.calib.CalibScreen;
import plfx.screen.utility.calib.DefaultCalibTemplate;

public class DefaultCalibScreen
implements CalibScreen {
    private DefaultCalibTemplate template;
    private CalibListener listener;
    private int clicked;

    public DefaultCalibScreen(DefaultCalibTemplate template) {
        if (template == null) {
            throw new NullPointerException("Template is not set");
        }
        this.template = template;
        template.getMark1().setOnMousePressed((EventHandler)new HitListener(template.getMark1(), 1));
        template.getMark2().setOnMousePressed((EventHandler)new HitListener(template.getMark2(), 2));
        template.getMark3().setOnMousePressed((EventHandler)new HitListener(template.getMark3(), 4));
        template.getMark4().setOnMousePressed((EventHandler)new HitListener(template.getMark4(), 8));
        template.getRepeatButton().setOnAction((EventHandler)new RepeatListener());
        template.getOkButton().setOnAction((EventHandler)new OkListener());
        template.getCancelButton().setOnAction((EventHandler)new CancelListener());
    }

    @Override
    public void init() {
        this.template.getOkButton().setDisable(true);
        this.processPane(this.template.getMark1(), "mark-default");
        this.processPane(this.template.getMark2(), "mark-default");
        this.processPane(this.template.getMark3(), "mark-default");
        this.processPane(this.template.getMark4(), "mark-default");
        this.clicked = 0;
    }

    @Override
    public void setListener(CalibListener listener) {
        if (listener == null) {
            throw new NullPointerException("CalibListener is not set");
        }
        this.listener = listener;
    }

    @Override
    public FxScreenTemplate getTemplate() {
        return this.template;
    }

    private void processOk() {
        this.template.getOkButton().setDisable((this.clicked & 0xF) != 15);
    }

    private void processPane(Pane pane, String styleClass) {
        pane.getStyleClass().clear();
        pane.getStyleClass().add((Object)styleClass);
    }

    private class CancelListener
    implements EventHandler<ActionEvent> {
        private CancelListener() {
        }

        public void handle(ActionEvent t) {
            if (DefaultCalibScreen.this.listener != null) {
                DefaultCalibScreen.this.listener.onCancel();
            }
        }
    }

    private class OkListener
    implements EventHandler<ActionEvent> {
        private OkListener() {
        }

        public void handle(ActionEvent t) {
            if (DefaultCalibScreen.this.listener != null) {
                DefaultCalibScreen.this.listener.onSuccess();
            }
        }
    }

    private class RepeatListener
    implements EventHandler<ActionEvent> {
        private RepeatListener() {
        }

        public void handle(ActionEvent t) {
            DefaultCalibScreen.this.init();
        }
    }

    private class HitListener
    implements EventHandler<MouseEvent> {
        private final Pane mark;
        private final int mask;

        public HitListener(Pane mark, int mask) {
            this.mark = mark;
            this.mask = mask;
        }

        public void handle(MouseEvent t) {
            DefaultCalibScreen.this.clicked = DefaultCalibScreen.this.clicked | this.mask;
            DefaultCalibScreen.this.processPane(this.mark, "mark-hit");
            DefaultCalibScreen.this.processOk();
        }
    }
}

