/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.popup.wait;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import plfx.Options;
import plfx.screen.popup.wait.WaitTemplate;
import plfx.screen.popup.wait.WaitTemplateCache;
import plfx.util.Locator;

public class WaitTemplateStore {
    private static volatile Map<String, String> mapping;
    private static final WaitTemplateCache store;
    private static final Logger log;

    public static WaitTemplate getTemplate(String waitId) {
        if (waitId == null) {
            throw new NullPointerException();
        }
        if (mapping == null && (mapping = WaitTemplateStore.loadFromJar()) == null) {
            mapping = new HashMap<String, String>();
        }
        String templateId = mapping.get(waitId);
        log.info((Object)("Template id: " + templateId));
        if (templateId == null) {
            templateId = "template";
            log.info((Object)"Use default template");
        }
        return (WaitTemplate)store.getObject(Locator.processPath("/gui/skin/{name}//popup/wait/" + templateId));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, String> loadFromJar() {
        InputStream is = Locator.getInputStream("/gui/popup/wait/mapping.properties");
        if (is == null) {
            return null;
        }
        try {
            Properties prop = new Properties();
            prop.load(is);
            HashMap<String, String> res = new HashMap<String, String>();
            for (String key : prop.stringPropertyNames()) {
                res.put(key, prop.getProperty(key));
            }
            HashMap<String, String> hashMap = res;
            return hashMap;
        }
        catch (IOException ex) {
            Map<String, String> map = null;
            return map;
        }
        finally {
            IOUtils.closeQuietly((InputStream)is);
        }
    }

    static {
        store = new WaitTemplateCache();
        log = Options.DEBUG;
    }
}

