/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.popup.wait;

import java.lang.reflect.Constructor;
import java.util.Properties;
import plfx.GuiNotifier;
import plfx.element.FxInitException;
import plfx.screen.ScreenCreateException;
import plfx.screen.popup.wait.DefaultWaitTemplate;
import plfx.screen.popup.wait.WaitTemplate;
import plfx.util.LoadTemplateException;
import plfx.util.Locator;
import plfx.util.ResourceLoader;

class WaitTemplateFactory {
    private WaitTemplateFactory() {
    }

    public static WaitTemplate create(String path) throws ScreenCreateException {
        try {
            Properties prop = Locator.readQuietly(path.replace("template", "descriptor") + ".properties", false);
            WaitTemplate template = null;
            String controller = prop.getProperty("controller", "");
            String bundle = prop.getProperty("bundle", "dlg");
            if (!controller.isEmpty()) {
                try {
                    Constructor<?> c = Class.forName(controller).getConstructor(String.class);
                    template = (WaitTemplate)c.newInstance(bundle);
                }
                catch (Throwable throwable) {
                    GuiNotifier.notifyError(throwable);
                    template = new DefaultWaitTemplate(bundle);
                }
            } else {
                template = new DefaultWaitTemplate(bundle);
            }
            ResourceLoader.load(Locator.getUrl(path + ".fxml"), template);
            template.init();
            return template;
        }
        catch (FxInitException | LoadTemplateException ex) {
            GuiNotifier.notifyError(ex);
            throw new ScreenCreateException(ex);
        }
    }
}

