/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.popup.dialog;

import java.nio.file.Paths;
import java.util.Properties;
import plfx.GuiNotifier;
import plfx.element.FxInitException;
import plfx.screen.popup.dialog.DefaultDialogTemplate;
import plfx.screen.popup.dialog.DialogTemplate;
import plfx.util.Cache;
import plfx.util.LoadTemplateException;
import plfx.util.Locator;
import plfx.util.ResourceLoader;

public class DialogTemplateStore
extends Cache<DialogTemplate> {
    private FxInitException initException;
    private LoadTemplateException templateException;

    public DialogTemplate getTemplate(String path) throws FxInitException, LoadTemplateException {
        DialogTemplate dt = (DialogTemplate)this.getObject(path);
        if (dt != null) {
            return dt;
        }
        if (this.initException != null) {
            throw this.initException;
        }
        if (this.templateException != null) {
            throw this.templateException;
        }
        throw new LoadTemplateException("Template " + path + " is not found");
    }

    @Override
    protected DialogTemplate load(String path) {
        this.initException = null;
        this.templateException = null;
        try {
            DialogTemplate dt;
            String id = Paths.get(path, new String[0]).getFileName().toString();
            String propPath = Paths.get(path, new String[0]).getParent().toString().replace("\\", "/") + "/descriptor.properties";
            Properties prop = Locator.readQuietly(propPath, false);
            String controllerName = prop.getProperty(id + ".controller", "");
            if (!controllerName.isEmpty()) {
                try {
                    dt = (DialogTemplate)Class.forName(controllerName).newInstance();
                }
                catch (Throwable throwable) {
                    GuiNotifier.notifyError(throwable);
                    dt = new DefaultDialogTemplate();
                }
            } else {
                dt = new DefaultDialogTemplate();
            }
            ResourceLoader.load(Locator.getUrl(path + ".fxml"), dt);
            dt.init();
            return dt;
        }
        catch (FxInitException ex) {
            this.initException = ex;
            GuiNotifier.notifyError(ex);
        }
        catch (LoadTemplateException ex) {
            this.templateException = ex;
            GuiNotifier.notifyError(ex);
        }
        return null;
    }
}

