/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.popup.dialog;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import plfx.GuiNotifier;
import plfx.screen.popup.dialog.DialogButton;
import plfx.screen.popup.dialog.DialogDescriptor;
import plfx.screen.popup.dialog.DialogDescriptorNotFoundException;
import plfx.util.Locator;

public class DialogDescriptorFactory {
    private static volatile DocumentBuilder dBuilder;

    public static DialogDescriptor create(String dialogId) throws DialogDescriptorNotFoundException {
        if (dialogId == null || dialogId.isEmpty()) {
            throw new NullPointerException("DialogId is not set");
        }
        return DialogDescriptorFactory.loadFromXmlFile(dialogId);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static DialogDescriptor loadFromXmlFile(String dialogId) throws DialogDescriptorNotFoundException {
        URL url = Locator.getUrl("/gui/skin/{name}/popup/dialog//" + dialogId + ".xml", false);
        if (url == null) {
            url = Locator.getUrl("/gui/popup/dialog//" + dialogId + ".xml");
        }
        if (url == null) {
            throw new DialogDescriptorNotFoundException("Dialog description " + dialogId + " is not found");
        }
        try (InputStream is = url.openStream();){
            Element messageSection;
            if (dBuilder == null) {
                DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
                dBuilder = dbFactory.newDocumentBuilder();
            }
            Document doc = dBuilder.parse(is);
            doc.getDocumentElement().normalize();
            Element root = doc.getDocumentElement();
            Element desc = DialogDescriptorFactory.getElement(root, "dialog");
            if (desc == null) {
                throw new DialogDescriptorNotFoundException("Dialog " + dialogId + ". Dialog section is not found");
            }
            String template = desc.getAttribute("template");
            String styleClass = desc.getAttribute("style");
            String bundle = desc.getAttribute("bundle");
            int timeout = DialogDescriptorFactory.getIntParam(desc.getAttribute("timeout"), "timeout", 0, 45);
            String title = DialogDescriptorFactory.getElementValue(desc, "title");
            if (title != null && title.matches("[a-zA-Z]+(\\.[a-zA-Z]+)+")) {
                GuiNotifier.notifyProblem("Dialog " + dialogId + " has suspicious title: " + title);
            }
            if ((messageSection = DialogDescriptorFactory.getElement(desc, "message")) == null) {
                throw new DialogDescriptorNotFoundException("Dialog " + dialogId + ". Message section is not found");
            }
            String message = DialogDescriptorFactory.getElementValue(desc, "message");
            if (message != null && message.matches("[a-zA-Z]+(\\.[a-zA-Z]+)+")) {
                GuiNotifier.notifyProblem("Dialog " + dialogId + " has suspicious message: " + message);
            }
            String handler = messageSection.getAttribute("handler");
            Element buttonsSection = DialogDescriptorFactory.getElement(desc, "buttons");
            if (buttonsSection == null) {
                throw new DialogDescriptorNotFoundException("Dialog " + dialogId + ". Buttons section is not found");
            }
            int defaultActionId = DialogDescriptorFactory.getIntParam(buttonsSection.getAttribute("default-action-id"), "default-action-id", -1, 100);
            NodeList buttonItems = buttonsSection.getElementsByTagName("button");
            boolean hasDefAction = false;
            DialogButton[] buttons = new DialogButton[buttonItems.getLength()];
            for (int i = 0; i < buttonItems.getLength(); ++i) {
                Element buttonElement = (Element)buttonItems.item(i);
                String buttonTitle = buttonElement.getAttribute("title");
                String buttonHint = buttonElement.getAttribute("hint");
                String buttonStyle = buttonElement.getAttribute("style");
                int actionId = DialogDescriptorFactory.getIntParam(buttonElement.getAttribute("action-id"), "action-id", 0, 100);
                buttons[i] = new DialogButton(buttonTitle, buttonHint, buttonStyle, actionId);
                if (actionId == defaultActionId) {
                    hasDefAction = true;
                }
                if (!buttonTitle.matches("[a-zA-Z]+(\\.[a-zA-Z]+)+")) continue;
                GuiNotifier.notifyProblem("Dialog " + dialogId + " has suspicious button title: " + buttonTitle);
            }
            if (!hasDefAction && defaultActionId != -1) {
                throw new DialogDescriptorNotFoundException("Dialog " + dialogId + ". Default action-id is not correspond to any button");
            }
            if (buttons.length == 2 && buttons[0].getActionId() == buttons[1].getActionId()) {
                throw new DialogDescriptorNotFoundException("Dialog " + dialogId + ". Button have same actions id: " + buttons[0].getActionId());
            }
            DialogDescriptor dialogDescriptor = new DialogDescriptor(title, handler, message, template, styleClass, timeout, buttons, defaultActionId, bundle);
            return dialogDescriptor;
        }
        catch (IOException | ParserConfigurationException | SAXException ex) {
            throw new DialogDescriptorNotFoundException(ex);
        }
    }

    private static int getIntParam(String value, String property, int min, int max) throws DialogDescriptorNotFoundException {
        if (value == null || !value.matches("^-?\\d+$")) {
            throw new DialogDescriptorNotFoundException("Property '" + property + "' is not found or wrong");
        }
        int res = Integer.parseInt(value);
        if (res < min || res > max) {
            throw new DialogDescriptorNotFoundException("Property '" + property + "' must be in range [" + min + ".." + max + "]");
        }
        return res;
    }

    private static String getElementValue(Element root, String name) {
        NodeList nl = root.getElementsByTagName(name);
        if (nl != null && nl.getLength() > 0) {
            Element val = (Element)nl.item(0);
            return val.getTextContent().trim().replace("\\n", "\n");
        }
        return null;
    }

    private static Element getElement(Element root, String name) {
        NodeList nl = root.getElementsByTagName(name);
        if (nl.getLength() > 0) {
            return (Element)nl.item(0);
        }
        return null;
    }
}

