/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.popup.dialog;

import java.util.Arrays;
import plfx.screen.popup.dialog.DialogButton;

public class DialogDescriptor {
    public static final String MSG_HANDLER_PAYLOGIC = "pl";
    public static final String MSG_HANDLER_VELOCITY = "vl";
    public static final String MSG_HANDLER_NONE = "nn";
    public static final String BUNDLE_SKIN = "skin";
    private final String title;
    private final String handler;
    private final String message;
    private final String template;
    private final String style;
    private final int timeout;
    private final DialogButton[] buttons;
    private final int defaultActionId;
    private final String bundle;

    public DialogDescriptor(String title, String handler, String message, String template, String style, int timeout, DialogButton[] buttons, int defaultActionId, String bundle) {
        this.title = title;
        this.handler = handler;
        this.message = message;
        this.template = template;
        this.style = style;
        this.timeout = timeout;
        this.defaultActionId = defaultActionId;
        this.bundle = bundle;
        this.buttons = buttons == null ? null : (DialogButton[])buttons.clone();
    }

    public String getTitle() {
        return this.title;
    }

    public String getHandler() {
        return this.handler;
    }

    public String getMessage() {
        return this.message;
    }

    public String getTemplate() {
        return this.template;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public DialogButton[] getButtons() {
        if (this.buttons == null) {
            return new DialogButton[0];
        }
        return (DialogButton[])this.buttons.clone();
    }

    public int getDefaultActionId() {
        return this.defaultActionId;
    }

    public boolean isSkinBundle() {
        return BUNDLE_SKIN.equalsIgnoreCase(this.bundle);
    }

    public String getStyle() {
        return this.style;
    }

    public String toString() {
        return "DialogDescriptor{title=" + this.title + ", handler=" + this.handler + ", message=" + this.message + ", template=" + this.template + ", style=" + this.style + ", timeout=" + this.timeout + ", buttons=" + Arrays.toString(this.buttons) + ", defaultActionId=" + this.defaultActionId + ", bundle=" + this.bundle + '}';
    }
}

