/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.popup.dialog;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import plfx.element.FxInitException;
import plfx.element.SButton;
import plfx.element.SLabel;
import plfx.msg.ScreenElement;
import plfx.msg.ScreenElementExtractor;
import plfx.screen.BaseFxScreenTemplate;
import plfx.screen.popup.dialog.DialogTemplate;

class DefaultDialogTemplate
extends BaseFxScreenTemplate
implements DialogTemplate {
    private SLabel sTitleLabel;
    private SLabel sMessageLabel;
    private SLabel sIdentificationLabel;
    private List<SButton> actionButtons;
    private List<ScreenElement> messages;
    private final Set<String> defStyles = new HashSet<String>();

    public DefaultDialogTemplate() {
        super("dialog.default", "skin");
    }

    @Override
    public void init() throws FxInitException {
        SButton actionButton;
        super.init();
        this.defStyles.addAll((Collection<String>)this.rootPane.getStyleClass());
        this.actionButtons = new LinkedList<SButton>();
        for (int i = 0; i < 10 && (actionButton = this.searchButton("actionButton" + i, false)) != null; ++i) {
            this.actionButtons.add(actionButton);
        }
        if (this.actionButtons.isEmpty()) {
            throw new FxInitException("ActionButton0 is not found");
        }
        this.sTitleLabel = this.searchScreenLabel("titleLabel", true);
        this.sMessageLabel = this.searchScreenLabel("messageLabel", true);
        this.sIdentificationLabel = this.searchScreenLabel("identificationLabel", true);
        this.messages = ScreenElementExtractor.getScreenElements((Node)this.rootPane);
    }

    @Override
    public List<ScreenElement> getElements() {
        return this.messages;
    }

    @Override
    public SLabel getTitleLabel() {
        return this.sTitleLabel;
    }

    @Override
    public SLabel getMessageLabel() {
        return this.sMessageLabel;
    }

    @Override
    public SLabel getIdentificationLabel() {
        return this.sIdentificationLabel;
    }

    public List<SButton> getActionButtons() {
        return this.actionButtons;
    }

    @Override
    public Pane getDialogNode() {
        return this.rootPane;
    }

    @Override
    public void setStyle(String style) {
        this.rootPane.getStyleClass().clear();
        this.rootPane.getStyleClass().addAll(this.defStyles);
        this.rootPane.getStyleClass().add((Object)style);
    }

    @Override
    public List<ScreenElement> getDynamicElements() {
        return null;
    }
}

