/*
 * Decompiled with CFR 0.152.
 */
package plfx.screen.popup.dialog;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javafx.scene.Node;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.Pane;
import plfx.element.ButtonListener;
import plfx.element.FxInitException;
import plfx.element.SButton;
import plfx.element.SLabel;
import plfx.element.ToggleSButton;
import plfx.msg.ScreenElement;
import plfx.msg.ScreenElementExtractor;
import plfx.screen.BaseFxScreenTemplate;
import plfx.screen.popup.dialog.DialogTemplate;

class ConfirmDialogTemplate
extends BaseFxScreenTemplate
implements DialogTemplate {
    private SLabel sTitleLabel;
    private SLabel sMessageLabel;
    private SLabel sIdentificationLabel;
    private List<ToggleSButton> checkButtons;
    private List<ScreenElement> messages;
    private SButton confirm;
    private final Set<String> defStyles = new HashSet<String>();

    public ConfirmDialogTemplate() {
        super("dialog.default", "skin");
    }

    @Override
    public void init() throws FxInitException {
        Node n;
        super.init();
        this.defStyles.addAll((Collection<String>)this.rootPane.getStyleClass());
        this.checkButtons = new LinkedList<ToggleSButton>();
        ToggleGroup tg = new ToggleGroup();
        for (int i = 0; i < 10 && (n = this.searchNode("actionCheck" + i)) instanceof ToggleButton; ++i) {
            ToggleButton tb = (ToggleButton)n;
            tb.setToggleGroup(tg);
            tb.setSelected(false);
            ToggleSButton tsb = new ToggleSButton(tb);
            tsb.setCheckedListener(this::confirmEnable);
            this.checkButtons.add(tsb);
        }
        if (this.checkButtons.isEmpty()) {
            throw new FxInitException("actionCheck0 is not found");
        }
        this.sTitleLabel = this.searchScreenLabel("titleLabel", true);
        this.sMessageLabel = this.searchScreenLabel("messageLabel", true);
        this.sIdentificationLabel = this.searchScreenLabel("identificationLabel", true);
        this.messages = ScreenElementExtractor.getScreenElements((Node)this.rootPane);
        this.confirm = this.searchButton("actionConfirm", false);
        this.confirm.setDisable(true);
    }

    @Override
    public List<ScreenElement> getElements() {
        return this.messages;
    }

    @Override
    public SLabel getTitleLabel() {
        return this.sTitleLabel;
    }

    @Override
    public SLabel getMessageLabel() {
        return this.sMessageLabel;
    }

    @Override
    public SLabel getIdentificationLabel() {
        return this.sIdentificationLabel;
    }

    @Override
    public List<? extends SButton> getActionButtons() {
        return this.checkButtons;
    }

    @Override
    public Pane getDialogNode() {
        return this.rootPane;
    }

    @Override
    public List<ScreenElement> getDynamicElements() {
        return null;
    }

    void confirmEnable(Boolean enable, ButtonListener listener) {
        this.confirm.setListener(() -> listener.onAction());
        this.confirm.setDisable(enable == false);
    }

    @Override
    public void setStyle(String style) {
        this.rootPane.getStyleClass().clear();
        this.rootPane.getStyleClass().addAll(this.defStyles);
        this.rootPane.getStyleClass().add((Object)style);
    }
}

